<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BKIRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ BRIRequest «Запрос сведений из банка данных для БКИ» | Данный документ используется передачи серверу МВВ запроса на
 * подготовку сведений из банка данных к выгрузке в Бюро кредитных историй.
 * - type: tns:BKIRequest
 * @subpackage Structs
 */
class BKIRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор запроса, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак запроса обновления | Признак запроса обновления. Если в этом поле стоит false, то запрашивается реестр целиком. | Обертка
     * стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The LastUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего реестра | Дата последнего выгруженного обновления реестра задолженности ФССП России, которое есть у Бюро
     * кредитных историй. | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $LastUnloadDate;
    /**
     * The DueUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата, по которую запрашиваются реестры изменений | Используются только при запросе изменений. При запросе полного реестра
     * задолженности ФССП России игнорируется. | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DueUnloadDate;
    /**
     * The ToFrom
     * Meta informations extracted from the WSDL
     * - documentation: Код территориального органа | Если поле заполнено, возвращается реестр ФССП России по указанному региону. | Ведомственный
     * классификатор территориальных отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $ToFrom;
    /**
     * Constructor method for BKIRequest
     * @uses BKIRequest::setExternalKey()
     * @uses BKIRequest::setIsUpdate()
     * @uses BKIRequest::setLastUnloadDate()
     * @uses BKIRequest::setDueUnloadDate()
     * @uses BKIRequest::setToFrom()
     * @param string $externalKey
     * @param bool $isUpdate
     * @param string $lastUnloadDate
     * @param string $dueUnloadDate
     * @param string $toFrom
     */
    public function __construct($externalKey = null, $isUpdate = null, $lastUnloadDate = null, $dueUnloadDate = null, $toFrom = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIsUpdate($isUpdate)
            ->setLastUnloadDate($lastUnloadDate)
            ->setDueUnloadDate($dueUnloadDate)
            ->setToFrom($toFrom);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\BKIRequest
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \AisFssp\StructType\BKIRequest
     */
    public function setIsUpdate($isUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdate) && !is_bool($isUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdate)), __LINE__);
        }
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get LastUnloadDate value
     * @return string|null
     */
    public function getLastUnloadDate()
    {
        return $this->LastUnloadDate;
    }
    /**
     * Set LastUnloadDate value
     * @param string $lastUnloadDate
     * @return \AisFssp\StructType\BKIRequest
     */
    public function setLastUnloadDate($lastUnloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($lastUnloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $lastUnloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($lastUnloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $lastUnloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastUnloadDate) && !is_string($lastUnloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUnloadDate)), __LINE__);
        }
        $this->LastUnloadDate = $lastUnloadDate;
        return $this;
    }
    /**
     * Get DueUnloadDate value
     * @return string|null
     */
    public function getDueUnloadDate()
    {
        return $this->DueUnloadDate;
    }
    /**
     * Set DueUnloadDate value
     * @param string $dueUnloadDate
     * @return \AisFssp\StructType\BKIRequest
     */
    public function setDueUnloadDate($dueUnloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($dueUnloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dueUnloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dueUnloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dueUnloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dueUnloadDate) && !is_string($dueUnloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueUnloadDate)), __LINE__);
        }
        $this->DueUnloadDate = $dueUnloadDate;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \AisFssp\StructType\BKIRequest
     */
    public function setToFrom($toFrom = null)
    {
        // validation for constraint: length
        if ((is_scalar($toFrom) && strlen($toFrom) !== 2) || (is_array($toFrom) && count($toFrom) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($toFrom) && !preg_match('/[0-9]{2}/', $toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($toFrom, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($toFrom) && !is_string($toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toFrom)), __LINE__);
        }
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\BKIRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
