<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccExtDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccExtDataType "Расширенные сведения о наличие денежных средств на счёте от налогового органа"
 * @subpackage Structs
 */
class AvailabilityAccExtDataType extends AvailabilityAccDataType
{
    /**
     * The IDDoc
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Строка длиной от 1 до 36 символов
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $IDDoc;
    /**
     * The QueryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса или решения налогового органа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $QueryNumber;
    /**
     * The QueryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса или решения налогового органа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $QueryDate;
    /**
     * The SOUN
     * Meta informations extracted from the WSDL
     * - documentation: Код налогового органа | Строка длиной от 1 до 4 символов
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $SOUN;
    /**
     * The InquiryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер справки | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $InquiryNumber;
    /**
     * The InquiryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата формирования справки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $InquiryDate;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование кредитной организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $BankName;
    /**
     * The RepresentativeBankFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО представителя банка
     * @var \AisFssp\StructType\FioType
     */
    public $RepresentativeBankFIO;
    /**
     * The RepresentativeBankPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность представителя банка | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $RepresentativeBankPost;
    /**
     * The TaxPayerName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование налогоплательщика | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TaxPayerName;
    /**
     * The TaxPayerFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО налогоплательщика
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $TaxPayerFIO;
    /**
     * The TaxPayerINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН налогоплательщика | ИНН
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $TaxPayerINN;
    /**
     * The TaxPayerKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП налогоплательщика | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $TaxPayerKPP;
    /**
     * The TaxPayerKIO
     * Meta informations extracted from the WSDL
     * - documentation: КИО налогоплательщика | Строка длиной от 1 до 5 символов
     * - minOccurs: 0
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $TaxPayerKIO;
    /**
     * The AccountKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид счета | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $AccountKind;
    /**
     * Constructor method for AvailabilityAccExtDataType
     * @uses AvailabilityAccExtDataType::setIDDoc()
     * @uses AvailabilityAccExtDataType::setQueryNumber()
     * @uses AvailabilityAccExtDataType::setQueryDate()
     * @uses AvailabilityAccExtDataType::setSOUN()
     * @uses AvailabilityAccExtDataType::setInquiryNumber()
     * @uses AvailabilityAccExtDataType::setInquiryDate()
     * @uses AvailabilityAccExtDataType::setBankName()
     * @uses AvailabilityAccExtDataType::setRepresentativeBankFIO()
     * @uses AvailabilityAccExtDataType::setRepresentativeBankPost()
     * @uses AvailabilityAccExtDataType::setTaxPayerName()
     * @uses AvailabilityAccExtDataType::setTaxPayerFIO()
     * @uses AvailabilityAccExtDataType::setTaxPayerINN()
     * @uses AvailabilityAccExtDataType::setTaxPayerKPP()
     * @uses AvailabilityAccExtDataType::setTaxPayerKIO()
     * @uses AvailabilityAccExtDataType::setAccountKind()
     * @param string $iDDoc
     * @param string $queryNumber
     * @param string $queryDate
     * @param string $sOUN
     * @param string $inquiryNumber
     * @param string $inquiryDate
     * @param string $bankName
     * @param \AisFssp\StructType\FioType $representativeBankFIO
     * @param string $representativeBankPost
     * @param string $taxPayerName
     * @param \AisFssp\StructType\FioType $taxPayerFIO
     * @param string $taxPayerINN
     * @param string $taxPayerKPP
     * @param string $taxPayerKIO
     * @param string $accountKind
     */
    public function __construct($iDDoc = null, $queryNumber = null, $queryDate = null, $sOUN = null, $inquiryNumber = null, $inquiryDate = null, $bankName = null, \AisFssp\StructType\FioType $representativeBankFIO = null, $representativeBankPost = null, $taxPayerName = null, \AisFssp\StructType\FioType $taxPayerFIO = null, $taxPayerINN = null, $taxPayerKPP = null, $taxPayerKIO = null, $accountKind = null)
    {
        $this
            ->setIDDoc($iDDoc)
            ->setQueryNumber($queryNumber)
            ->setQueryDate($queryDate)
            ->setSOUN($sOUN)
            ->setInquiryNumber($inquiryNumber)
            ->setInquiryDate($inquiryDate)
            ->setBankName($bankName)
            ->setRepresentativeBankFIO($representativeBankFIO)
            ->setRepresentativeBankPost($representativeBankPost)
            ->setTaxPayerName($taxPayerName)
            ->setTaxPayerFIO($taxPayerFIO)
            ->setTaxPayerINN($taxPayerINN)
            ->setTaxPayerKPP($taxPayerKPP)
            ->setTaxPayerKIO($taxPayerKIO)
            ->setAccountKind($accountKind);
    }
    /**
     * Get IDDoc value
     * @return string|null
     */
    public function getIDDoc()
    {
        return $this->IDDoc;
    }
    /**
     * Set IDDoc value
     * @param string $iDDoc
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setIDDoc($iDDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDDoc) && strlen($iDDoc) > 36) || (is_array($iDDoc) && count($iDDoc) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($iDDoc) ? strlen($iDDoc) : count($iDDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDDoc) && strlen($iDDoc) < 1) || (is_array($iDDoc) && count($iDDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDoc) && !is_string($iDDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDoc)), __LINE__);
        }
        $this->IDDoc = $iDDoc;
        return $this;
    }
    /**
     * Get QueryNumber value
     * @return string|null
     */
    public function getQueryNumber()
    {
        return $this->QueryNumber;
    }
    /**
     * Set QueryNumber value
     * @param string $queryNumber
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setQueryNumber($queryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queryNumber) && strlen($queryNumber) > 25) || (is_array($queryNumber) && count($queryNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($queryNumber) ? strlen($queryNumber) : count($queryNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($queryNumber) && strlen($queryNumber) < 1) || (is_array($queryNumber) && count($queryNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryNumber) && !is_string($queryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryNumber)), __LINE__);
        }
        $this->QueryNumber = $queryNumber;
        return $this;
    }
    /**
     * Get QueryDate value
     * @return string|null
     */
    public function getQueryDate()
    {
        return $this->QueryDate;
    }
    /**
     * Set QueryDate value
     * @param string $queryDate
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setQueryDate($queryDate = null)
    {
        // validation for constraint: maxExclusive
        if ($queryDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $queryDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($queryDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $queryDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryDate) && !is_string($queryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryDate)), __LINE__);
        }
        $this->QueryDate = $queryDate;
        return $this;
    }
    /**
     * Get SOUN value
     * @return string|null
     */
    public function getSOUN()
    {
        return $this->SOUN;
    }
    /**
     * Set SOUN value
     * @param string $sOUN
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setSOUN($sOUN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sOUN) && strlen($sOUN) > 4) || (is_array($sOUN) && count($sOUN) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($sOUN) ? strlen($sOUN) : count($sOUN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sOUN) && strlen($sOUN) < 1) || (is_array($sOUN) && count($sOUN) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sOUN) && !is_string($sOUN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sOUN)), __LINE__);
        }
        $this->SOUN = $sOUN;
        return $this;
    }
    /**
     * Get InquiryNumber value
     * @return string|null
     */
    public function getInquiryNumber()
    {
        return $this->InquiryNumber;
    }
    /**
     * Set InquiryNumber value
     * @param string $inquiryNumber
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setInquiryNumber($inquiryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($inquiryNumber) && strlen($inquiryNumber) > 25) || (is_array($inquiryNumber) && count($inquiryNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($inquiryNumber) ? strlen($inquiryNumber) : count($inquiryNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($inquiryNumber) && strlen($inquiryNumber) < 1) || (is_array($inquiryNumber) && count($inquiryNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inquiryNumber) && !is_string($inquiryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inquiryNumber)), __LINE__);
        }
        $this->InquiryNumber = $inquiryNumber;
        return $this;
    }
    /**
     * Get InquiryDate value
     * @return string|null
     */
    public function getInquiryDate()
    {
        return $this->InquiryDate;
    }
    /**
     * Set InquiryDate value
     * @param string $inquiryDate
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setInquiryDate($inquiryDate = null)
    {
        // validation for constraint: maxExclusive
        if ($inquiryDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $inquiryDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($inquiryDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $inquiryDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inquiryDate) && !is_string($inquiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inquiryDate)), __LINE__);
        }
        $this->InquiryDate = $inquiryDate;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankName) && strlen($bankName) > 1000) || (is_array($bankName) && count($bankName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($bankName) ? strlen($bankName) : count($bankName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankName) && strlen($bankName) < 1) || (is_array($bankName) && count($bankName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get RepresentativeBankFIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getRepresentativeBankFIO()
    {
        return $this->RepresentativeBankFIO;
    }
    /**
     * Set RepresentativeBankFIO value
     * @param \AisFssp\StructType\FioType $representativeBankFIO
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setRepresentativeBankFIO(\AisFssp\StructType\FioType $representativeBankFIO = null)
    {
        $this->RepresentativeBankFIO = $representativeBankFIO;
        return $this;
    }
    /**
     * Get RepresentativeBankPost value
     * @return string|null
     */
    public function getRepresentativeBankPost()
    {
        return $this->RepresentativeBankPost;
    }
    /**
     * Set RepresentativeBankPost value
     * @param string $representativeBankPost
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setRepresentativeBankPost($representativeBankPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($representativeBankPost) && strlen($representativeBankPost) > 100) || (is_array($representativeBankPost) && count($representativeBankPost) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($representativeBankPost) ? strlen($representativeBankPost) : count($representativeBankPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($representativeBankPost) && strlen($representativeBankPost) < 1) || (is_array($representativeBankPost) && count($representativeBankPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($representativeBankPost) && !is_string($representativeBankPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($representativeBankPost)), __LINE__);
        }
        $this->RepresentativeBankPost = $representativeBankPost;
        return $this;
    }
    /**
     * Get TaxPayerName value
     * @return string|null
     */
    public function getTaxPayerName()
    {
        return $this->TaxPayerName;
    }
    /**
     * Set TaxPayerName value
     * @param string $taxPayerName
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerName($taxPayerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($taxPayerName) && strlen($taxPayerName) > 1000) || (is_array($taxPayerName) && count($taxPayerName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($taxPayerName) ? strlen($taxPayerName) : count($taxPayerName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($taxPayerName) && strlen($taxPayerName) < 1) || (is_array($taxPayerName) && count($taxPayerName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxPayerName) && !is_string($taxPayerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxPayerName)), __LINE__);
        }
        $this->TaxPayerName = $taxPayerName;
        return $this;
    }
    /**
     * Get TaxPayerFIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getTaxPayerFIO()
    {
        return $this->TaxPayerFIO;
    }
    /**
     * Set TaxPayerFIO value
     * @param \AisFssp\StructType\FioType $taxPayerFIO
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerFIO(\AisFssp\StructType\FioType $taxPayerFIO = null)
    {
        $this->TaxPayerFIO = $taxPayerFIO;
        return $this;
    }
    /**
     * Get TaxPayerINN value
     * @return string|null
     */
    public function getTaxPayerINN()
    {
        return $this->TaxPayerINN;
    }
    /**
     * Set TaxPayerINN value
     * @param string $taxPayerINN
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerINN($taxPayerINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($taxPayerINN) && strlen($taxPayerINN) > 12) || (is_array($taxPayerINN) && count($taxPayerINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($taxPayerINN) ? strlen($taxPayerINN) : count($taxPayerINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($taxPayerINN) && strlen($taxPayerINN) < 10) || (is_array($taxPayerINN) && count($taxPayerINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($taxPayerINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $taxPayerINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($taxPayerINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxPayerINN) && !is_string($taxPayerINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxPayerINN)), __LINE__);
        }
        $this->TaxPayerINN = $taxPayerINN;
        return $this;
    }
    /**
     * Get TaxPayerKPP value
     * @return string|null
     */
    public function getTaxPayerKPP()
    {
        return $this->TaxPayerKPP;
    }
    /**
     * Set TaxPayerKPP value
     * @param string $taxPayerKPP
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerKPP($taxPayerKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($taxPayerKPP) && strlen($taxPayerKPP) !== 9) || (is_array($taxPayerKPP) && count($taxPayerKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($taxPayerKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $taxPayerKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($taxPayerKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxPayerKPP) && !is_string($taxPayerKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxPayerKPP)), __LINE__);
        }
        $this->TaxPayerKPP = $taxPayerKPP;
        return $this;
    }
    /**
     * Get TaxPayerKIO value
     * @return string|null
     */
    public function getTaxPayerKIO()
    {
        return $this->TaxPayerKIO;
    }
    /**
     * Set TaxPayerKIO value
     * @param string $taxPayerKIO
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerKIO($taxPayerKIO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($taxPayerKIO) && strlen($taxPayerKIO) > 5) || (is_array($taxPayerKIO) && count($taxPayerKIO) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($taxPayerKIO) ? strlen($taxPayerKIO) : count($taxPayerKIO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($taxPayerKIO) && strlen($taxPayerKIO) < 1) || (is_array($taxPayerKIO) && count($taxPayerKIO) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxPayerKIO) && !is_string($taxPayerKIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxPayerKIO)), __LINE__);
        }
        $this->TaxPayerKIO = $taxPayerKIO;
        return $this;
    }
    /**
     * Get AccountKind value
     * @return string|null
     */
    public function getAccountKind()
    {
        return $this->AccountKind;
    }
    /**
     * Set AccountKind value
     * @param string $accountKind
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public function setAccountKind($accountKind = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountKind) && strlen($accountKind) > 255) || (is_array($accountKind) && count($accountKind) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($accountKind) ? strlen($accountKind) : count($accountKind)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountKind) && strlen($accountKind) < 1) || (is_array($accountKind) && count($accountKind) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountKind) && !is_string($accountKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountKind)), __LINE__);
        }
        $this->AccountKind = $accountKind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
