<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных AttachmentType "Прикрепленный файл"
 * @subpackage Structs
 */
class AttachmentType extends AbstractStructBase
{
    /**
     * The fileName
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $fileName;
    /**
     * The fileTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип прикреплённого файла
     * - minOccurs: 0
     * @var string
     */
    public $fileTypeCode;
    /**
     * The contentType
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип вложения
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $contentType;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Данные
     * - expectedContentTypes: application/pdf
     * @var string
     */
    public $data;
    /**
     * Constructor method for AttachmentType
     * @uses AttachmentType::setFileName()
     * @uses AttachmentType::setFileTypeCode()
     * @uses AttachmentType::setContentType()
     * @uses AttachmentType::setData()
     * @param string $fileName
     * @param string $fileTypeCode
     * @param string $contentType
     * @param string $data
     */
    public function __construct($fileName = null, $fileTypeCode = null, $contentType = null, $data = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileTypeCode($fileTypeCode)
            ->setContentType($contentType)
            ->setData($data);
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \AisFssp\StructType\AttachmentType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fileName) && strlen($fileName) > 100) || (is_array($fileName) && count($fileName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($fileName) ? strlen($fileName) : count($fileName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($fileName) && strlen($fileName) < 1) || (is_array($fileName) && count($fileName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileTypeCode value
     * @return string|null
     */
    public function getFileTypeCode()
    {
        return $this->fileTypeCode;
    }
    /**
     * Set fileTypeCode value
     * @uses \AisFssp\EnumType\FileType::valueIsValid()
     * @uses \AisFssp\EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileTypeCode
     * @return \AisFssp\StructType\AttachmentType
     */
    public function setFileTypeCode($fileTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\FileType::valueIsValid($fileTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fileTypeCode, implode(', ', \AisFssp\EnumType\FileType::getValidValues())), __LINE__);
        }
        $this->fileTypeCode = $fileTypeCode;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \AisFssp\StructType\AttachmentType
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contentType) && strlen($contentType) > 255) || (is_array($contentType) && count($contentType) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($contentType) ? strlen($contentType) : count($contentType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contentType) && strlen($contentType) < 1) || (is_array($contentType) && count($contentType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \AisFssp\StructType\AttachmentType
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
