<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrestRegistryInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра арестованного имущество отправленного на реализацию | ЭП
 * - type: tns:ArrestRegistryInfo
 * @subpackage Structs
 */
class ArrestRegistryInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса (значение поля ExternalKey), переданного ранее в ФССП России. | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The isActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сведений | Признак наличия сведений об арестованном имущество отправленного на реализацию. | Обертка
     * стандартного xs:boolean | Логический
     * @var bool
     */
    public $isActInfo;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - documentation: Состав выписки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ArrestRegistryDetail[]
     */
    public $Detail;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for ArrestRegistryInfo
     * @uses ArrestRegistryInfo::setInternalKey()
     * @uses ArrestRegistryInfo::setQueryExternalKey()
     * @uses ArrestRegistryInfo::setIsActInfo()
     * @uses ArrestRegistryInfo::setDetail()
     * @uses ArrestRegistryInfo::setSignDateTime()
     * @uses ArrestRegistryInfo::setSignature()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param bool $isActInfo
     * @param \AisFssp\StructType\ArrestRegistryDetail[] $detail
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $isActInfo = null, array $detail = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setIsActInfo($isActInfo)
            ->setDetail($detail)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) > 60) || (is_array($queryExternalKey) && count($queryExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($queryExternalKey) ? strlen($queryExternalKey) : count($queryExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) < 1) || (is_array($queryExternalKey) && count($queryExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryExternalKey) && !is_string($queryExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryExternalKey)), __LINE__);
        }
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get isActInfo value
     * @return bool|null
     */
    public function getIsActInfo()
    {
        return $this->isActInfo;
    }
    /**
     * Set isActInfo value
     * @param bool $isActInfo
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setIsActInfo($isActInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActInfo) && !is_bool($isActInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActInfo)), __LINE__);
        }
        $this->isActInfo = $isActInfo;
        return $this;
    }
    /**
     * Get Detail value
     * @return \AisFssp\StructType\ArrestRegistryDetail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryDetail[] $detail
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setDetail(array $detail = array())
    {
        foreach ($detail as $arrestRegistryInfoDetailItem) {
            // validation for constraint: itemType
            if (!$arrestRegistryInfoDetailItem instanceof \AisFssp\StructType\ArrestRegistryDetail) {
                throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of \AisFssp\StructType\ArrestRegistryDetail, "%s" given', is_object($arrestRegistryInfoDetailItem) ? get_class($arrestRegistryInfoDetailItem) : gettype($arrestRegistryInfoDetailItem)), __LINE__);
            }
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryDetail $item
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function addToDetail(\AisFssp\StructType\ArrestRegistryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ArrestRegistryDetail) {
            throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of \AisFssp\StructType\ArrestRegistryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $arrestRegistryInfoSignatureItem) {
            // validation for constraint: itemType
            if (!$arrestRegistryInfoSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($arrestRegistryInfoSignatureItem) ? get_class($arrestRegistryInfoSignatureItem) : gettype($arrestRegistryInfoSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ArrestRegistryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
