<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrestRecoveryAmountDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестованных и взысканных средствах
 * @subpackage Structs
 */
class ArrestRecoveryAmountDataType extends AccountDatumType
{
    /**
     * The ArrestAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста в валюте счета | Заполняется для передачи данных об исполнении постановления об аресте средств, постановления о
     * снятии ареста. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ArrestAmount;
    /**
     * The ArrestAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста в рублях | Заполняется для передачи данных об исполнении постановления об аресте средств, постановления о снятии
     * ареста. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ArrestAmountRub;
    /**
     * The RecoveryAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания в валюте счета | Заполняется для передачи данных об исполнении постановления о взыскании средств,
     * постановления об отмене обращения взыскания. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RecoveryAmount;
    /**
     * The RecoveryAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания в рублях | Заполняется для передачи данных об исполнении постановления о взыскании средств, постановления об
     * отмене обращения взыскания. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RecoveryAmountRub;
    /**
     * The ArrestRecoveryState
     * Meta informations extracted from the WSDL
     * - documentation: Статус ареста и взыскания
     * - minOccurs: 0
     * @var string
     */
    public $ArrestRecoveryState;
    /**
     * Constructor method for ArrestRecoveryAmountDataType
     * @uses ArrestRecoveryAmountDataType::setArrestAmount()
     * @uses ArrestRecoveryAmountDataType::setArrestAmountRub()
     * @uses ArrestRecoveryAmountDataType::setRecoveryAmount()
     * @uses ArrestRecoveryAmountDataType::setRecoveryAmountRub()
     * @uses ArrestRecoveryAmountDataType::setArrestRecoveryState()
     * @param float $arrestAmount
     * @param float $arrestAmountRub
     * @param float $recoveryAmount
     * @param float $recoveryAmountRub
     * @param string $arrestRecoveryState
     */
    public function __construct($arrestAmount = null, $arrestAmountRub = null, $recoveryAmount = null, $recoveryAmountRub = null, $arrestRecoveryState = null)
    {
        $this
            ->setArrestAmount($arrestAmount)
            ->setArrestAmountRub($arrestAmountRub)
            ->setRecoveryAmount($recoveryAmount)
            ->setRecoveryAmountRub($recoveryAmountRub)
            ->setArrestRecoveryState($arrestRecoveryState);
    }
    /**
     * Get ArrestAmount value
     * @return float|null
     */
    public function getArrestAmount()
    {
        return $this->ArrestAmount;
    }
    /**
     * Set ArrestAmount value
     * @param float $arrestAmount
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestAmount($arrestAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($arrestAmount) && strlen(substr($arrestAmount, strpos($arrestAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($arrestAmount, strpos($arrestAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($arrestAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $arrestAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($arrestAmount, strpos($arrestAmount, '.')))), __LINE__);
        }
        $this->ArrestAmount = $arrestAmount;
        return $this;
    }
    /**
     * Get ArrestAmountRub value
     * @return float|null
     */
    public function getArrestAmountRub()
    {
        return $this->ArrestAmountRub;
    }
    /**
     * Set ArrestAmountRub value
     * @param float $arrestAmountRub
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestAmountRub($arrestAmountRub = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($arrestAmountRub) && strlen(substr($arrestAmountRub, strpos($arrestAmountRub, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($arrestAmountRub, strpos($arrestAmountRub, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($arrestAmountRub) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $arrestAmountRub)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($arrestAmountRub, strpos($arrestAmountRub, '.')))), __LINE__);
        }
        $this->ArrestAmountRub = $arrestAmountRub;
        return $this;
    }
    /**
     * Get RecoveryAmount value
     * @return float|null
     */
    public function getRecoveryAmount()
    {
        return $this->RecoveryAmount;
    }
    /**
     * Set RecoveryAmount value
     * @param float $recoveryAmount
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public function setRecoveryAmount($recoveryAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($recoveryAmount) && strlen(substr($recoveryAmount, strpos($recoveryAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($recoveryAmount, strpos($recoveryAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($recoveryAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $recoveryAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($recoveryAmount, strpos($recoveryAmount, '.')))), __LINE__);
        }
        $this->RecoveryAmount = $recoveryAmount;
        return $this;
    }
    /**
     * Get RecoveryAmountRub value
     * @return float|null
     */
    public function getRecoveryAmountRub()
    {
        return $this->RecoveryAmountRub;
    }
    /**
     * Set RecoveryAmountRub value
     * @param float $recoveryAmountRub
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public function setRecoveryAmountRub($recoveryAmountRub = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($recoveryAmountRub) && strlen(substr($recoveryAmountRub, strpos($recoveryAmountRub, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($recoveryAmountRub, strpos($recoveryAmountRub, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($recoveryAmountRub) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $recoveryAmountRub)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($recoveryAmountRub, strpos($recoveryAmountRub, '.')))), __LINE__);
        }
        $this->RecoveryAmountRub = $recoveryAmountRub;
        return $this;
    }
    /**
     * Get ArrestRecoveryState value
     * @return string|null
     */
    public function getArrestRecoveryState()
    {
        return $this->ArrestRecoveryState;
    }
    /**
     * Set ArrestRecoveryState value
     * @uses \AisFssp\EnumType\ArrestRecoveryStateType::valueIsValid()
     * @uses \AisFssp\EnumType\ArrestRecoveryStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrestRecoveryState
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestRecoveryState($arrestRecoveryState = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ArrestRecoveryStateType::valueIsValid($arrestRecoveryState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrestRecoveryState, implode(', ', \AisFssp\EnumType\ArrestRecoveryStateType::getValidValues())), __LINE__);
        }
        $this->ArrestRecoveryState = $arrestRecoveryState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
