<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных AddressType «Адрес»
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: При отсутствии данных в этом поле, объект, адрес которого задаётся, считается находящимся в Российской Федерации (код страны 643)
     * | Код страны цифровой | Цифровой код страны по ОКСМ
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $countryCode;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТMО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - documentation: Индекс | Почтовый индекс
     * - minOccurs: 0
     * - length: 6
     * - pattern: [0-9]{6}
     * @var string
     */
    public $zipCode;
    /**
     * The regionCode
     * Meta informations extracted from the WSDL
     * - documentation: Область | Код региона по КЛАДР
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $regionCode;
    /**
     * The area
     * Meta informations extracted from the WSDL
     * - documentation: Район | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $area;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - documentation: Город | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $city;
    /**
     * The settlement
     * Meta informations extracted from the WSDL
     * - documentation: Населенный пункт | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $settlement;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - documentation: Улица | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Дом | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $houseNumber;
    /**
     * The buildingNumber
     * Meta informations extracted from the WSDL
     * - documentation: Корпус | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $buildingNumber;
    /**
     * The structureNumber
     * Meta informations extracted from the WSDL
     * - documentation: Строение/владение | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $structureNumber;
    /**
     * The flatNumber
     * Meta informations extracted from the WSDL
     * - documentation: Квартира | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $flatNumber;
    /**
     * The kladrRegion
     * Meta informations extracted from the WSDL
     * - documentation: Код региона | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrRegion;
    /**
     * The kladrArea
     * Meta informations extracted from the WSDL
     * - documentation: Код района | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrArea;
    /**
     * The kladrCity
     * Meta informations extracted from the WSDL
     * - documentation: Код города или населенного пункта | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrCity;
    /**
     * The kladrSettlement
     * Meta informations extracted from the WSDL
     * - documentation: Код населенного пункта | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrSettlement;
    /**
     * The kladrStreet
     * Meta informations extracted from the WSDL
     * - documentation: Код улицы | Код КЛАДР второго раздела | Код КЛАДР второго раздела
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $kladrStreet;
    /**
     * The addressText
     * Meta informations extracted from the WSDL
     * - documentation: Адрес в произвольном формате | Может заполняться в случае, если указывается иностранный адрес (указан код страны, отличный от
     * 643). | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $addressText;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setCountryCode()
     * @uses AddressType::setOKATO()
     * @uses AddressType::setOKTMO()
     * @uses AddressType::setZipCode()
     * @uses AddressType::setRegionCode()
     * @uses AddressType::setArea()
     * @uses AddressType::setCity()
     * @uses AddressType::setSettlement()
     * @uses AddressType::setStreet()
     * @uses AddressType::setHouseNumber()
     * @uses AddressType::setBuildingNumber()
     * @uses AddressType::setStructureNumber()
     * @uses AddressType::setFlatNumber()
     * @uses AddressType::setKladrRegion()
     * @uses AddressType::setKladrArea()
     * @uses AddressType::setKladrCity()
     * @uses AddressType::setKladrSettlement()
     * @uses AddressType::setKladrStreet()
     * @uses AddressType::setAddressText()
     * @param string $countryCode
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $zipCode
     * @param string $regionCode
     * @param string $area
     * @param string $city
     * @param string $settlement
     * @param string $street
     * @param string $houseNumber
     * @param string $buildingNumber
     * @param string $structureNumber
     * @param string $flatNumber
     * @param string $kladrRegion
     * @param string $kladrArea
     * @param string $kladrCity
     * @param string $kladrSettlement
     * @param string $kladrStreet
     * @param string $addressText
     */
    public function __construct($countryCode = null, $oKATO = null, $oKTMO = null, $zipCode = null, $regionCode = null, $area = null, $city = null, $settlement = null, $street = null, $houseNumber = null, $buildingNumber = null, $structureNumber = null, $flatNumber = null, $kladrRegion = null, $kladrArea = null, $kladrCity = null, $kladrSettlement = null, $kladrStreet = null, $addressText = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setZipCode($zipCode)
            ->setRegionCode($regionCode)
            ->setArea($area)
            ->setCity($city)
            ->setSettlement($settlement)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setBuildingNumber($buildingNumber)
            ->setStructureNumber($structureNumber)
            ->setFlatNumber($flatNumber)
            ->setKladrRegion($kladrRegion)
            ->setKladrArea($kladrArea)
            ->setKladrCity($kladrCity)
            ->setKladrSettlement($kladrSettlement)
            ->setKladrStreet($kladrStreet)
            ->setAddressText($addressText);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \AisFssp\StructType\AddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($countryCode) && strlen($countryCode) !== 3) || (is_array($countryCode) && count($countryCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[0-9]{3}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3}", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \AisFssp\StructType\AddressType
     */
    public function setOKATO($oKATO = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKATO) && strlen($oKATO) !== 11) || (is_array($oKATO) && count($oKATO) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKATO) && !preg_match('/[0-9]{11}/', $oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($oKATO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKATO) && !is_string($oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKATO)), __LINE__);
        }
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \AisFssp\StructType\AddressType
     */
    public function setOKTMO($oKTMO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) > 11) || (is_array($oKTMO) && count($oKTMO) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($oKTMO) ? strlen($oKTMO) : count($oKTMO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) < 8) || (is_array($oKTMO) && count($oKTMO) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKTMO) && !preg_match('/([0-9]{8})|([0-9]{11})/', $oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{8})|([0-9]{11})", "%s" given', var_export($oKTMO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKTMO) && !is_string($oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKTMO)), __LINE__);
        }
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \AisFssp\StructType\AddressType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($zipCode) && strlen($zipCode) !== 6) || (is_array($zipCode) && count($zipCode) !== 6)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($zipCode) && !preg_match('/[0-9]{6}/', $zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{6}", "%s" given', var_export($zipCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \AisFssp\StructType\AddressType
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($regionCode) && strlen($regionCode) !== 2) || (is_array($regionCode) && count($regionCode) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($regionCode) && !preg_match('/[0-9]{2}/', $regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($regionCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \AisFssp\StructType\AddressType
     */
    public function setArea($area = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($area) && strlen($area) > 60) || (is_array($area) && count($area) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($area) ? strlen($area) : count($area)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($area) && strlen($area) < 1) || (is_array($area) && count($area) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \AisFssp\StructType\AddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 60) || (is_array($city) && count($city) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get settlement value
     * @return string|null
     */
    public function getSettlement()
    {
        return $this->settlement;
    }
    /**
     * Set settlement value
     * @param string $settlement
     * @return \AisFssp\StructType\AddressType
     */
    public function setSettlement($settlement = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($settlement) && strlen($settlement) > 60) || (is_array($settlement) && count($settlement) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($settlement) ? strlen($settlement) : count($settlement)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($settlement) && strlen($settlement) < 1) || (is_array($settlement) && count($settlement) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($settlement) && !is_string($settlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settlement)), __LINE__);
        }
        $this->settlement = $settlement;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \AisFssp\StructType\AddressType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 60) || (is_array($street) && count($street) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($street) && strlen($street) < 1) || (is_array($street) && count($street) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \AisFssp\StructType\AddressType
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) > 10) || (is_array($houseNumber) && count($houseNumber) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($houseNumber) ? strlen($houseNumber) : count($houseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) < 1) || (is_array($houseNumber) && count($houseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get buildingNumber value
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return $this->buildingNumber;
    }
    /**
     * Set buildingNumber value
     * @param string $buildingNumber
     * @return \AisFssp\StructType\AddressType
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($buildingNumber) && strlen($buildingNumber) > 8) || (is_array($buildingNumber) && count($buildingNumber) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($buildingNumber) ? strlen($buildingNumber) : count($buildingNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($buildingNumber) && strlen($buildingNumber) < 1) || (is_array($buildingNumber) && count($buildingNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingNumber)), __LINE__);
        }
        $this->buildingNumber = $buildingNumber;
        return $this;
    }
    /**
     * Get structureNumber value
     * @return string|null
     */
    public function getStructureNumber()
    {
        return $this->structureNumber;
    }
    /**
     * Set structureNumber value
     * @param string $structureNumber
     * @return \AisFssp\StructType\AddressType
     */
    public function setStructureNumber($structureNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($structureNumber) && strlen($structureNumber) > 8) || (is_array($structureNumber) && count($structureNumber) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($structureNumber) ? strlen($structureNumber) : count($structureNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($structureNumber) && strlen($structureNumber) < 1) || (is_array($structureNumber) && count($structureNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($structureNumber) && !is_string($structureNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($structureNumber)), __LINE__);
        }
        $this->structureNumber = $structureNumber;
        return $this;
    }
    /**
     * Get flatNumber value
     * @return string|null
     */
    public function getFlatNumber()
    {
        return $this->flatNumber;
    }
    /**
     * Set flatNumber value
     * @param string $flatNumber
     * @return \AisFssp\StructType\AddressType
     */
    public function setFlatNumber($flatNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($flatNumber) && strlen($flatNumber) > 8) || (is_array($flatNumber) && count($flatNumber) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($flatNumber) ? strlen($flatNumber) : count($flatNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($flatNumber) && strlen($flatNumber) < 1) || (is_array($flatNumber) && count($flatNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flatNumber) && !is_string($flatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flatNumber)), __LINE__);
        }
        $this->flatNumber = $flatNumber;
        return $this;
    }
    /**
     * Get kladrRegion value
     * @return string|null
     */
    public function getKladrRegion()
    {
        return $this->kladrRegion;
    }
    /**
     * Set kladrRegion value
     * @param string $kladrRegion
     * @return \AisFssp\StructType\AddressType
     */
    public function setKladrRegion($kladrRegion = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrRegion) && strlen($kladrRegion) !== 11) || (is_array($kladrRegion) && count($kladrRegion) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrRegion) && !preg_match('/[0-9]{11}/', $kladrRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($kladrRegion, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrRegion) && !is_string($kladrRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrRegion)), __LINE__);
        }
        $this->kladrRegion = $kladrRegion;
        return $this;
    }
    /**
     * Get kladrArea value
     * @return string|null
     */
    public function getKladrArea()
    {
        return $this->kladrArea;
    }
    /**
     * Set kladrArea value
     * @param string $kladrArea
     * @return \AisFssp\StructType\AddressType
     */
    public function setKladrArea($kladrArea = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrArea) && strlen($kladrArea) !== 11) || (is_array($kladrArea) && count($kladrArea) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrArea) && !preg_match('/[0-9]{11}/', $kladrArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($kladrArea, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrArea) && !is_string($kladrArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrArea)), __LINE__);
        }
        $this->kladrArea = $kladrArea;
        return $this;
    }
    /**
     * Get kladrCity value
     * @return string|null
     */
    public function getKladrCity()
    {
        return $this->kladrCity;
    }
    /**
     * Set kladrCity value
     * @param string $kladrCity
     * @return \AisFssp\StructType\AddressType
     */
    public function setKladrCity($kladrCity = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrCity) && strlen($kladrCity) !== 11) || (is_array($kladrCity) && count($kladrCity) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrCity) && !preg_match('/[0-9]{11}/', $kladrCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($kladrCity, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrCity) && !is_string($kladrCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrCity)), __LINE__);
        }
        $this->kladrCity = $kladrCity;
        return $this;
    }
    /**
     * Get kladrSettlement value
     * @return string|null
     */
    public function getKladrSettlement()
    {
        return $this->kladrSettlement;
    }
    /**
     * Set kladrSettlement value
     * @param string $kladrSettlement
     * @return \AisFssp\StructType\AddressType
     */
    public function setKladrSettlement($kladrSettlement = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrSettlement) && strlen($kladrSettlement) !== 11) || (is_array($kladrSettlement) && count($kladrSettlement) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrSettlement) && !preg_match('/[0-9]{11}/', $kladrSettlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($kladrSettlement, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrSettlement) && !is_string($kladrSettlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrSettlement)), __LINE__);
        }
        $this->kladrSettlement = $kladrSettlement;
        return $this;
    }
    /**
     * Get kladrStreet value
     * @return string|null
     */
    public function getKladrStreet()
    {
        return $this->kladrStreet;
    }
    /**
     * Set kladrStreet value
     * @param string $kladrStreet
     * @return \AisFssp\StructType\AddressType
     */
    public function setKladrStreet($kladrStreet = null)
    {
        // validation for constraint: length
        if ((is_scalar($kladrStreet) && strlen($kladrStreet) !== 15) || (is_array($kladrStreet) && count($kladrStreet) !== 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kladrStreet) && !preg_match('/[0-9]{15}/', $kladrStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{15}", "%s" given', var_export($kladrStreet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kladrStreet) && !is_string($kladrStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kladrStreet)), __LINE__);
        }
        $this->kladrStreet = $kladrStreet;
        return $this;
    }
    /**
     * Get addressText value
     * @return string|null
     */
    public function getAddressText()
    {
        return $this->addressText;
    }
    /**
     * Set addressText value
     * @param string $addressText
     * @return \AisFssp\StructType\AddressType
     */
    public function setAddressText($addressText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressText) && strlen($addressText) > 300) || (is_array($addressText) && count($addressText) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($addressText) ? strlen($addressText) : count($addressText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($addressText) && strlen($addressText) < 1) || (is_array($addressText) && count($addressText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressText) && !is_string($addressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressText)), __LINE__);
        }
        $this->addressText = $addressText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
