<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер AccountType "Состояние счета"
 * @subpackage Structs
 */
class AccountType extends AbstractStructBase
{
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - documentation: Код счета | Код счета из справочника «Бухгалтерские счета» | Код счета | NSI_MVV_AccountingAccountCode
     * - maxLength: 13
     * - minLength: 1
     * @var string
     */
    public $AccountCode;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for AccountType
     * @uses AccountType::setAccountCode()
     * @uses AccountType::setAmount()
     * @param string $accountCode
     * @param float $amount
     */
    public function __construct($accountCode = null, $amount = null)
    {
        $this
            ->setAccountCode($accountCode)
            ->setAmount($amount);
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \AisFssp\StructType\AccountType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountCode) && strlen($accountCode) > 13) || (is_array($accountCode) && count($accountCode) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($accountCode) ? strlen($accountCode) : count($accountCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountCode) && strlen($accountCode) < 1) || (is_array($accountCode) && count($accountCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\AccountType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
