<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountTransactionDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об операциях по счету
 * @subpackage Structs
 */
class AccountTransactionDatumType extends InformationType
{
    /**
     * The IsArchive
     * Meta informations extracted from the WSDL
     * - documentation: Признак архивного счета | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsArchive;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * @var string
     */
    public $TransactionType;
    /**
     * The BIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BIK;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Счет | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата операции | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $TransactionDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма операции | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The ContragentName
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ContragentName;
    /**
     * The CorrBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка корреспондента | Банковский идентификационный код (БИК)
     * - minOccurs: 0
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $CorrBIK;
    /**
     * The CorrAccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Кор.счет | Указывается номер корреспондентского счета. Поле обязательно для заполнения если тип операции «1» - Приход, «2» -
     * Расход. Поле необязательно для заполнения в случае если тип операции «3» - Остаток на начало, «4» - Остаток на конец. Поле необязательно
     * для заполнения при передачи сведений о платежах в адрес Федерального казначейства | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $CorrAccountNumber;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for AccountTransactionDatumType
     * @uses AccountTransactionDatumType::setIsArchive()
     * @uses AccountTransactionDatumType::setTransactionType()
     * @uses AccountTransactionDatumType::setBIK()
     * @uses AccountTransactionDatumType::setAccountNumber()
     * @uses AccountTransactionDatumType::setTransactionDate()
     * @uses AccountTransactionDatumType::setAmount()
     * @uses AccountTransactionDatumType::setContragentName()
     * @uses AccountTransactionDatumType::setCorrBIK()
     * @uses AccountTransactionDatumType::setCorrAccountNumber()
     * @uses AccountTransactionDatumType::setGrounds()
     * @param bool $isArchive
     * @param string $transactionType
     * @param string $bIK
     * @param string $accountNumber
     * @param string $transactionDate
     * @param float $amount
     * @param string $contragentName
     * @param string $corrBIK
     * @param string $corrAccountNumber
     * @param string $grounds
     */
    public function __construct($isArchive = null, $transactionType = null, $bIK = null, $accountNumber = null, $transactionDate = null, $amount = null, $contragentName = null, $corrBIK = null, $corrAccountNumber = null, $grounds = null)
    {
        $this
            ->setIsArchive($isArchive)
            ->setTransactionType($transactionType)
            ->setBIK($bIK)
            ->setAccountNumber($accountNumber)
            ->setTransactionDate($transactionDate)
            ->setAmount($amount)
            ->setContragentName($contragentName)
            ->setCorrBIK($corrBIK)
            ->setCorrAccountNumber($corrAccountNumber)
            ->setGrounds($grounds);
    }
    /**
     * Get IsArchive value
     * @return bool|null
     */
    public function getIsArchive()
    {
        return $this->IsArchive;
    }
    /**
     * Set IsArchive value
     * @param bool $isArchive
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setIsArchive($isArchive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchive) && !is_bool($isArchive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isArchive)), __LINE__);
        }
        $this->IsArchive = $isArchive;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \AisFssp\EnumType\AccountTransactionType::valueIsValid()
     * @uses \AisFssp\EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\AccountTransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \AisFssp\EnumType\AccountTransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get BIK value
     * @return string|null
     */
    public function getBIK()
    {
        return $this->BIK;
    }
    /**
     * Set BIK value
     * @param string $bIK
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setBIK($bIK = null)
    {
        // validation for constraint: length
        if ((is_scalar($bIK) && strlen($bIK) !== 9) || (is_array($bIK) && count($bIK) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bIK) && !preg_match('/[0-9]{9}/', $bIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($bIK, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bIK) && !is_string($bIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIK)), __LINE__);
        }
        $this->BIK = $bIK;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) > 20) || (is_array($accountNumber) && count($accountNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($accountNumber) ? strlen($accountNumber) : count($accountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) < 1) || (is_array($accountNumber) && count($accountNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: maxExclusive
        if ($transactionDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $transactionDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($transactionDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $transactionDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ContragentName value
     * @return string|null
     */
    public function getContragentName()
    {
        return $this->ContragentName;
    }
    /**
     * Set ContragentName value
     * @param string $contragentName
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setContragentName($contragentName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contragentName) && strlen($contragentName) > 1000) || (is_array($contragentName) && count($contragentName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($contragentName) ? strlen($contragentName) : count($contragentName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contragentName) && strlen($contragentName) < 1) || (is_array($contragentName) && count($contragentName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contragentName) && !is_string($contragentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contragentName)), __LINE__);
        }
        $this->ContragentName = $contragentName;
        return $this;
    }
    /**
     * Get CorrBIK value
     * @return string|null
     */
    public function getCorrBIK()
    {
        return $this->CorrBIK;
    }
    /**
     * Set CorrBIK value
     * @param string $corrBIK
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setCorrBIK($corrBIK = null)
    {
        // validation for constraint: length
        if ((is_scalar($corrBIK) && strlen($corrBIK) !== 9) || (is_array($corrBIK) && count($corrBIK) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($corrBIK) && !preg_match('/[0-9]{9}/', $corrBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($corrBIK, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($corrBIK) && !is_string($corrBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corrBIK)), __LINE__);
        }
        $this->CorrBIK = $corrBIK;
        return $this;
    }
    /**
     * Get CorrAccountNumber value
     * @return string|null
     */
    public function getCorrAccountNumber()
    {
        return $this->CorrAccountNumber;
    }
    /**
     * Set CorrAccountNumber value
     * @param string $corrAccountNumber
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setCorrAccountNumber($corrAccountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($corrAccountNumber) && strlen($corrAccountNumber) > 20) || (is_array($corrAccountNumber) && count($corrAccountNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($corrAccountNumber) ? strlen($corrAccountNumber) : count($corrAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($corrAccountNumber) && strlen($corrAccountNumber) < 1) || (is_array($corrAccountNumber) && count($corrAccountNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($corrAccountNumber) && !is_string($corrAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corrAccountNumber)), __LINE__);
        }
        $this->CorrAccountNumber = $corrAccountNumber;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public function setGrounds($grounds = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($grounds) && strlen($grounds) > 1000) || (is_array($grounds) && count($grounds) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($grounds) ? strlen($grounds) : count($grounds)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($grounds) && strlen($grounds) < 1) || (is_array($grounds) && count($grounds) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grounds) && !is_string($grounds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grounds)), __LINE__);
        }
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountTransactionDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
