<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountExtDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расширенные сведения о банковском счете
 * @subpackage Structs
 */
class AccountExtDatumType extends AccountDatumType
{
    /**
     * The accountTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа банковского счёта | Строка длиной 2 символа
     * - length: 2
     * @var string
     */
    public $accountTypeCode;
    /**
     * The accountTypeName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа банковского счёта | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $accountTypeName;
    /**
     * Constructor method for AccountExtDatumType
     * @uses AccountExtDatumType::setAccountTypeCode()
     * @uses AccountExtDatumType::setAccountTypeName()
     * @param string $accountTypeCode
     * @param string $accountTypeName
     */
    public function __construct($accountTypeCode = null, $accountTypeName = null)
    {
        $this
            ->setAccountTypeCode($accountTypeCode)
            ->setAccountTypeName($accountTypeName);
    }
    /**
     * Get accountTypeCode value
     * @return string|null
     */
    public function getAccountTypeCode()
    {
        return $this->accountTypeCode;
    }
    /**
     * Set accountTypeCode value
     * @param string $accountTypeCode
     * @return \AisFssp\StructType\AccountExtDatumType
     */
    public function setAccountTypeCode($accountTypeCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($accountTypeCode) && strlen($accountTypeCode) !== 2) || (is_array($accountTypeCode) && count($accountTypeCode) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountTypeCode) && !is_string($accountTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeCode)), __LINE__);
        }
        $this->accountTypeCode = $accountTypeCode;
        return $this;
    }
    /**
     * Get accountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->accountTypeName;
    }
    /**
     * Set accountTypeName value
     * @param string $accountTypeName
     * @return \AisFssp\StructType\AccountExtDatumType
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountTypeName) && strlen($accountTypeName) > 255) || (is_array($accountTypeName) && count($accountTypeName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($accountTypeName) ? strlen($accountTypeName) : count($accountTypeName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountTypeName) && strlen($accountTypeName) < 1) || (is_array($accountTypeName) && count($accountTypeName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->accountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountExtDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
