<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountEncumbranceDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестах и обременениях
 * @subpackage Structs
 */
class AccountEncumbranceDatumType extends AccountDatumType
{
    /**
     * The EncumbranceOrg
     * Meta informations extracted from the WSDL
     * - documentation: Организация
     * @var string
     */
    public $EncumbranceOrg;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста/обременения | Поле обязательное к заполнению, может не заполняться если в поле «Организация» указано значение ФНС
     * России | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - documentation: Дата ареста | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $Date;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Очерёдность | Очередность
     * - minOccurs: 0
     * - maxInclusive: 5
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер Постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * Constructor method for AccountEncumbranceDatumType
     * @uses AccountEncumbranceDatumType::setEncumbranceOrg()
     * @uses AccountEncumbranceDatumType::setAmount()
     * @uses AccountEncumbranceDatumType::setDate()
     * @uses AccountEncumbranceDatumType::setPriority()
     * @uses AccountEncumbranceDatumType::setIPNumber()
     * @uses AccountEncumbranceDatumType::setDocNumber()
     * @uses AccountEncumbranceDatumType::setOSPCode()
     * @uses AccountEncumbranceDatumType::setSPIFio()
     * @uses AccountEncumbranceDatumType::setSPIPost()
     * @uses AccountEncumbranceDatumType::setSPITel()
     * @param string $encumbranceOrg
     * @param float $amount
     * @param string $date
     * @param int $priority
     * @param string $iPNumber
     * @param string $docNumber
     * @param string $oSPCode
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $sPITel
     */
    public function __construct($encumbranceOrg = null, $amount = null, $date = null, $priority = null, $iPNumber = null, $docNumber = null, $oSPCode = null, $sPIFio = null, $sPIPost = null, $sPITel = null)
    {
        $this
            ->setEncumbranceOrg($encumbranceOrg)
            ->setAmount($amount)
            ->setDate($date)
            ->setPriority($priority)
            ->setIPNumber($iPNumber)
            ->setDocNumber($docNumber)
            ->setOSPCode($oSPCode)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setSPITel($sPITel);
    }
    /**
     * Get EncumbranceOrg value
     * @return string|null
     */
    public function getEncumbranceOrg()
    {
        return $this->EncumbranceOrg;
    }
    /**
     * Set EncumbranceOrg value
     * @uses \AisFssp\EnumType\EncumbranceOrgType::valueIsValid()
     * @uses \AisFssp\EnumType\EncumbranceOrgType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encumbranceOrg
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setEncumbranceOrg($encumbranceOrg = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\EncumbranceOrgType::valueIsValid($encumbranceOrg)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encumbranceOrg, implode(', ', \AisFssp\EnumType\EncumbranceOrgType::getValidValues())), __LINE__);
        }
        $this->EncumbranceOrg = $encumbranceOrg;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setDate($date = null)
    {
        // validation for constraint: maxExclusive
        if ($date >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $date), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($date < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $date), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: maxInclusive
        if ($priority > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 5, "%s" given', $priority), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($priority < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $priority), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setIPNumber($iPNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) > 25) || (is_array($iPNumber) && count($iPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumber) ? strlen($iPNumber) : count($iPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumber) && strlen($iPNumber) < 1) || (is_array($iPNumber) && count($iPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNumber) && !is_string($iPNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNumber)), __LINE__);
        }
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setOSPCode($oSPCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oSPCode) && strlen($oSPCode) !== 5) || (is_array($oSPCode) && count($oSPCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oSPCode) && !preg_match('/[0-9]{5}/', $oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($oSPCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPCode) && !is_string($oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPCode)), __LINE__);
        }
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public function setSPITel($sPITel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITel) && strlen($sPITel) > 25) || (is_array($sPITel) && count($sPITel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITel) ? strlen($sPITel) : count($sPITel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITel) && strlen($sPITel) < 1) || (is_array($sPITel) && count($sPITel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITel) && !is_string($sPITel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITel)), __LINE__);
        }
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
