<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о банковском счете
 * @subpackage Structs
 */
class AccountDatumType extends InformationType
{
    /**
     * The Acc
     * Meta informations extracted from the WSDL
     * - documentation: Счет | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Acc;
    /**
     * The PersonalAcc
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAcc;
    /**
     * The BicBank
     * Meta informations extracted from the WSDL
     * - documentation: БИК | Обязательно к заполнению для кредитных организаций. БИК банка (филиала) или учреждения Банка России, исполняющего решение
     * или запрос. | Банковский идентификационный код (БИК)
     * - minOccurs: 0
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BicBank;
    /**
     * The bankORGN
     * Meta informations extracted from the WSDL
     * - documentation: Основной государственный регистрационный номер кредитной организации | Основной государственный регистрационный номер
     * (ОГРН)
     * - minOccurs: 0
     * - length: 13
     * - pattern: [0-9]{13}
     * @var string
     */
    public $bankORGN;
    /**
     * The bankINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН кредитной организации | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $bankINN;
    /**
     * The bankKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП кредитной организации | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $bankKPP;
    /**
     * The contractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора банковского счета | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $contractNumber;
    /**
     * The contractStartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractStartDate;
    /**
     * The contractFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractFinDate;
    /**
     * The accountKindCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида банковского счёта
     * - minOccurs: 0
     * @var string
     */
    public $accountKindCode;
    /**
     * The accountKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование счёта | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $accountKindName;
    /**
     * Constructor method for AccountDatumType
     * @uses AccountDatumType::setAcc()
     * @uses AccountDatumType::setPersonalAcc()
     * @uses AccountDatumType::setBicBank()
     * @uses AccountDatumType::setBankORGN()
     * @uses AccountDatumType::setBankINN()
     * @uses AccountDatumType::setBankKPP()
     * @uses AccountDatumType::setContractNumber()
     * @uses AccountDatumType::setContractStartDate()
     * @uses AccountDatumType::setContractFinDate()
     * @uses AccountDatumType::setAccountKindCode()
     * @uses AccountDatumType::setAccountKindName()
     * @param string $acc
     * @param string $personalAcc
     * @param string $bicBank
     * @param string $bankORGN
     * @param string $bankINN
     * @param string $bankKPP
     * @param string $contractNumber
     * @param string $contractStartDate
     * @param string $contractFinDate
     * @param string $accountKindCode
     * @param string $accountKindName
     */
    public function __construct($acc = null, $personalAcc = null, $bicBank = null, $bankORGN = null, $bankINN = null, $bankKPP = null, $contractNumber = null, $contractStartDate = null, $contractFinDate = null, $accountKindCode = null, $accountKindName = null)
    {
        $this
            ->setAcc($acc)
            ->setPersonalAcc($personalAcc)
            ->setBicBank($bicBank)
            ->setBankORGN($bankORGN)
            ->setBankINN($bankINN)
            ->setBankKPP($bankKPP)
            ->setContractNumber($contractNumber)
            ->setContractStartDate($contractStartDate)
            ->setContractFinDate($contractFinDate)
            ->setAccountKindCode($accountKindCode)
            ->setAccountKindName($accountKindName);
    }
    /**
     * Get Acc value
     * @return string|null
     */
    public function getAcc()
    {
        return $this->Acc;
    }
    /**
     * Set Acc value
     * @param string $acc
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setAcc($acc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($acc) && strlen($acc) > 20) || (is_array($acc) && count($acc) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($acc) ? strlen($acc) : count($acc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($acc) && strlen($acc) < 1) || (is_array($acc) && count($acc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acc) && !is_string($acc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acc)), __LINE__);
        }
        $this->Acc = $acc;
        return $this;
    }
    /**
     * Get PersonalAcc value
     * @return string|null
     */
    public function getPersonalAcc()
    {
        return $this->PersonalAcc;
    }
    /**
     * Set PersonalAcc value
     * @param string $personalAcc
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setPersonalAcc($personalAcc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($personalAcc) && strlen($personalAcc) > 25) || (is_array($personalAcc) && count($personalAcc) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($personalAcc) ? strlen($personalAcc) : count($personalAcc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($personalAcc) && strlen($personalAcc) < 1) || (is_array($personalAcc) && count($personalAcc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($personalAcc) && !is_string($personalAcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalAcc)), __LINE__);
        }
        $this->PersonalAcc = $personalAcc;
        return $this;
    }
    /**
     * Get BicBank value
     * @return string|null
     */
    public function getBicBank()
    {
        return $this->BicBank;
    }
    /**
     * Set BicBank value
     * @param string $bicBank
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setBicBank($bicBank = null)
    {
        // validation for constraint: length
        if ((is_scalar($bicBank) && strlen($bicBank) !== 9) || (is_array($bicBank) && count($bicBank) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bicBank) && !preg_match('/[0-9]{9}/', $bicBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($bicBank, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bicBank) && !is_string($bicBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bicBank)), __LINE__);
        }
        $this->BicBank = $bicBank;
        return $this;
    }
    /**
     * Get bankORGN value
     * @return string|null
     */
    public function getBankORGN()
    {
        return $this->bankORGN;
    }
    /**
     * Set bankORGN value
     * @param string $bankORGN
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setBankORGN($bankORGN = null)
    {
        // validation for constraint: length
        if ((is_scalar($bankORGN) && strlen($bankORGN) !== 13) || (is_array($bankORGN) && count($bankORGN) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bankORGN) && !preg_match('/[0-9]{13}/', $bankORGN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{13}", "%s" given', var_export($bankORGN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankORGN) && !is_string($bankORGN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankORGN)), __LINE__);
        }
        $this->bankORGN = $bankORGN;
        return $this;
    }
    /**
     * Get bankINN value
     * @return string|null
     */
    public function getBankINN()
    {
        return $this->bankINN;
    }
    /**
     * Set bankINN value
     * @param string $bankINN
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setBankINN($bankINN = null)
    {
        // validation for constraint: length
        if ((is_scalar($bankINN) && strlen($bankINN) !== 10) || (is_array($bankINN) && count($bankINN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bankINN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $bankINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($bankINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankINN) && !is_string($bankINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankINN)), __LINE__);
        }
        $this->bankINN = $bankINN;
        return $this;
    }
    /**
     * Get bankKPP value
     * @return string|null
     */
    public function getBankKPP()
    {
        return $this->bankKPP;
    }
    /**
     * Set bankKPP value
     * @param string $bankKPP
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setBankKPP($bankKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($bankKPP) && strlen($bankKPP) !== 9) || (is_array($bankKPP) && count($bankKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bankKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $bankKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($bankKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankKPP) && !is_string($bankKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankKPP)), __LINE__);
        }
        $this->bankKPP = $bankKPP;
        return $this;
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) > 20) || (is_array($contractNumber) && count($contractNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($contractNumber) ? strlen($contractNumber) : count($contractNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) < 1) || (is_array($contractNumber) && count($contractNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get contractStartDate value
     * @return string|null
     */
    public function getContractStartDate()
    {
        return $this->contractStartDate;
    }
    /**
     * Set contractStartDate value
     * @param string $contractStartDate
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setContractStartDate($contractStartDate = null)
    {
        // validation for constraint: maxExclusive
        if ($contractStartDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $contractStartDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($contractStartDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $contractStartDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractStartDate) && !is_string($contractStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractStartDate)), __LINE__);
        }
        $this->contractStartDate = $contractStartDate;
        return $this;
    }
    /**
     * Get contractFinDate value
     * @return string|null
     */
    public function getContractFinDate()
    {
        return $this->contractFinDate;
    }
    /**
     * Set contractFinDate value
     * @param string $contractFinDate
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setContractFinDate($contractFinDate = null)
    {
        // validation for constraint: maxExclusive
        if ($contractFinDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $contractFinDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($contractFinDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $contractFinDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractFinDate) && !is_string($contractFinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractFinDate)), __LINE__);
        }
        $this->contractFinDate = $contractFinDate;
        return $this;
    }
    /**
     * Get accountKindCode value
     * @return string|null
     */
    public function getAccountKindCode()
    {
        return $this->accountKindCode;
    }
    /**
     * Set accountKindCode value
     * @uses \AisFssp\EnumType\AccountKindCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\AccountKindCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountKindCode
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setAccountKindCode($accountKindCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\AccountKindCodeType::valueIsValid($accountKindCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountKindCode, implode(', ', \AisFssp\EnumType\AccountKindCodeType::getValidValues())), __LINE__);
        }
        $this->accountKindCode = $accountKindCode;
        return $this;
    }
    /**
     * Get accountKindName value
     * @return string|null
     */
    public function getAccountKindName()
    {
        return $this->accountKindName;
    }
    /**
     * Set accountKindName value
     * @param string $accountKindName
     * @return \AisFssp\StructType\AccountDatumType
     */
    public function setAccountKindName($accountKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountKindName) && strlen($accountKindName) > 500) || (is_array($accountKindName) && count($accountKindName) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($accountKindName) ? strlen($accountKindName) : count($accountKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($accountKindName) && strlen($accountKindName) < 1) || (is_array($accountKindName) && count($accountKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountKindName) && !is_string($accountKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountKindName)), __LINE__);
        }
        $this->accountKindName = $accountKindName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AccountDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
