<?php

namespace AisFssp\EnumType;

/**
 * This class stands for WarrantTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип доверенности
 * @subpackage Enumerations
 */
class WarrantTypeType
{
    /**
     * Constant for value '01'
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
