<?php

namespace AisFssp\EnumType;

/**
 * This class stands for ProcessResult EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Результат обработки пакета, документа или квитанции
 * @subpackage Enumerations
 */
class ProcessResult
{
    /**
     * Constant for value 'SUCCESS'
     * @return string 'SUCCESS'
     */
    const VALUE_SUCCESS = 'SUCCESS';
    /**
     * Constant for value 'PARTIALLY'
     * @return string 'PARTIALLY'
     */
    const VALUE_PARTIALLY = 'PARTIALLY';
    /**
     * Constant for value 'FAIL'
     * @return string 'FAIL'
     */
    const VALUE_FAIL = 'FAIL';
    /**
     * Constant for value 'WAIT'
     * @return string 'WAIT'
     */
    const VALUE_WAIT = 'WAIT';
    /**
     * Constant for value 'CONFIRMATION'
     * @return string 'CONFIRMATION'
     */
    const VALUE_CONFIRMATION = 'CONFIRMATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_PARTIALLY
     * @uses self::VALUE_FAIL
     * @uses self::VALUE_WAIT
     * @uses self::VALUE_CONFIRMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_PARTIALLY,
            self::VALUE_FAIL,
            self::VALUE_WAIT,
            self::VALUE_CONFIRMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
