<?php

namespace AisFssp\EnumType;

/**
 * This class stands for Priority EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Приоритет пакета
 * @subpackage Enumerations
 */
class Priority
{
    /**
     * Constant for value '-20'
     * @return string '-20'
     */
    const VALUE_20 = '-20';
    /**
     * Constant for value '-10'
     * @return string '-10'
     */
    const VALUE_10 = '-10';
    /**
     * Constant for value '0'
     * @return string '0'
     */
    const VALUE_0 = '0';
    /**
     * Constant for value '10'
     * @return string '10'
     */
    const VALUE_10_1 = '10';
    /**
     * Constant for value '20'
     * @return string '20'
     */
    const VALUE_20_1 = '20';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_20
     * @uses self::VALUE_10
     * @uses self::VALUE_0
     * @uses self::VALUE_10_1
     * @uses self::VALUE_20_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_20,
            self::VALUE_10,
            self::VALUE_0,
            self::VALUE_10_1,
            self::VALUE_20_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
