<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRegister StructType
 * @subpackage Structs
 */
class PaymentRegister extends AbstractStructBase
{
    /**
     * The PaymentCenterCode
     * @var int
     */
    public $PaymentCenterCode;
    /**
     * The PaymentSubAgencyCode
     * @var string
     */
    public $PaymentSubAgencyCode;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentAmount
     * @var float
     */
    public $PaymentAmount;
    /**
     * The CheckNumber
     * @var string
     */
    public $CheckNumber;
    /**
     * The AuxData
     * @var string
     */
    public $AuxData;
    /**
     * The RecordType
     * @var string
     */
    public $RecordType;
    /**
     * The ExternalData
     * @var int
     */
    public $ExternalData;
    /**
     * The ListData
     * @var \StructType\ListData
     */
    public $ListData;
    /**
     * Constructor method for PaymentRegister
     * @uses PaymentRegister::setPaymentCenterCode()
     * @uses PaymentRegister::setPaymentSubAgencyCode()
     * @uses PaymentRegister::setReferenceNumber()
     * @uses PaymentRegister::setPaymentDate()
     * @uses PaymentRegister::setPaymentAmount()
     * @uses PaymentRegister::setCheckNumber()
     * @uses PaymentRegister::setAuxData()
     * @uses PaymentRegister::setRecordType()
     * @uses PaymentRegister::setExternalData()
     * @uses PaymentRegister::setListData()
     * @param int $paymentCenterCode
     * @param string $paymentSubAgencyCode
     * @param string $referenceNumber
     * @param string $paymentDate
     * @param float $paymentAmount
     * @param string $checkNumber
     * @param string $auxData
     * @param string $recordType
     * @param int $externalData
     * @param \StructType\ListData $listData
     */
    public function __construct($paymentCenterCode = null, $paymentSubAgencyCode = null, $referenceNumber = null, $paymentDate = null, $paymentAmount = null, $checkNumber = null, $auxData = null, $recordType = null, $externalData = null, \StructType\ListData $listData = null)
    {
        $this
            ->setPaymentCenterCode($paymentCenterCode)
            ->setPaymentSubAgencyCode($paymentSubAgencyCode)
            ->setReferenceNumber($referenceNumber)
            ->setPaymentDate($paymentDate)
            ->setPaymentAmount($paymentAmount)
            ->setCheckNumber($checkNumber)
            ->setAuxData($auxData)
            ->setRecordType($recordType)
            ->setExternalData($externalData)
            ->setListData($listData);
    }
    /**
     * Get PaymentCenterCode value
     * @return int|null
     */
    public function getPaymentCenterCode()
    {
        return $this->PaymentCenterCode;
    }
    /**
     * Set PaymentCenterCode value
     * @param int $paymentCenterCode
     * @return \StructType\PaymentRegister
     */
    public function setPaymentCenterCode($paymentCenterCode = null)
    {
        // validation for constraint: int
        if (!is_null($paymentCenterCode) && !is_numeric($paymentCenterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentCenterCode)), __LINE__);
        }
        $this->PaymentCenterCode = $paymentCenterCode;
        return $this;
    }
    /**
     * Get PaymentSubAgencyCode value
     * @return string|null
     */
    public function getPaymentSubAgencyCode()
    {
        return $this->PaymentSubAgencyCode;
    }
    /**
     * Set PaymentSubAgencyCode value
     * @param string $paymentSubAgencyCode
     * @return \StructType\PaymentRegister
     */
    public function setPaymentSubAgencyCode($paymentSubAgencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSubAgencyCode) && !is_string($paymentSubAgencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentSubAgencyCode)), __LINE__);
        }
        $this->PaymentSubAgencyCode = $paymentSubAgencyCode;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\PaymentRegister
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\PaymentRegister
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\PaymentRegister
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\PaymentRegister
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get AuxData value
     * @return string|null
     */
    public function getAuxData()
    {
        return $this->AuxData;
    }
    /**
     * Set AuxData value
     * @param string $auxData
     * @return \StructType\PaymentRegister
     */
    public function setAuxData($auxData = null)
    {
        // validation for constraint: string
        if (!is_null($auxData) && !is_string($auxData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auxData)), __LINE__);
        }
        $this->AuxData = $auxData;
        return $this;
    }
    /**
     * Get RecordType value
     * @return string|null
     */
    public function getRecordType()
    {
        return $this->RecordType;
    }
    /**
     * Set RecordType value
     * @param string $recordType
     * @return \StructType\PaymentRegister
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: string
        if (!is_null($recordType) && !is_string($recordType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordType)), __LINE__);
        }
        $this->RecordType = $recordType;
        return $this;
    }
    /**
     * Get ExternalData value
     * @return int|null
     */
    public function getExternalData()
    {
        return $this->ExternalData;
    }
    /**
     * Set ExternalData value
     * @param int $externalData
     * @return \StructType\PaymentRegister
     */
    public function setExternalData($externalData = null)
    {
        // validation for constraint: int
        if (!is_null($externalData) && !is_numeric($externalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalData)), __LINE__);
        }
        $this->ExternalData = $externalData;
        return $this;
    }
    /**
     * Get ListData value
     * @return \StructType\ListData|null
     */
    public function getListData()
    {
        return $this->ListData;
    }
    /**
     * Set ListData value
     * @param \StructType\ListData $listData
     * @return \StructType\PaymentRegister
     */
    public function setListData(\StructType\ListData $listData = null)
    {
        $this->ListData = $listData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentRegister
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
