<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Payment ServiceType
 * @subpackage Services
 */
class Payment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PaymentRegister
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PaymentRegister $parameters
     * @return \StructType\PaymentRegisterResponse|bool
     */
    public function PaymentRegister(\StructType\PaymentRegister $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PaymentRegister($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PaymentRegisterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
