<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationType StructType
 * @subpackage Structs
 */
class VerificationType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PersonName
     */
    public $PersonName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmailType
     */
    public $Email;
    /**
     * The TelephoneInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TelephoneInfo
     */
    public $TelephoneInfo;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AddressInfoType
     */
    public $AddressInfo;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType[]
     */
    public $Vendor;
    /**
     * The ReservationTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ReservationTimeSpan
     */
    public $ReservationTimeSpan;
    /**
     * The AssociatedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AssociatedQuantity[]
     */
    public $AssociatedQuantity;
    /**
     * The StartLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\StartLocation
     */
    public $StartLocation;
    /**
     * The EndLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EndLocation
     */
    public $EndLocation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VerificationType
     * @uses VerificationType::setPersonName()
     * @uses VerificationType::setEmail()
     * @uses VerificationType::setTelephoneInfo()
     * @uses VerificationType::setPaymentCard()
     * @uses VerificationType::setAddressInfo()
     * @uses VerificationType::setCustLoyalty()
     * @uses VerificationType::setVendor()
     * @uses VerificationType::setReservationTimeSpan()
     * @uses VerificationType::setAssociatedQuantity()
     * @uses VerificationType::setStartLocation()
     * @uses VerificationType::setEndLocation()
     * @uses VerificationType::setTPA_Extensions()
     * @param \rdyescapiacontent\StructType\PersonName $personName
     * @param \rdyescapiacontent\StructType\EmailType $email
     * @param \rdyescapiacontent\StructType\TelephoneInfo $telephoneInfo
     * @param \rdyescapiacontent\StructType\PaymentCardType $paymentCard
     * @param \rdyescapiacontent\StructType\AddressInfoType $addressInfo
     * @param \rdyescapiacontent\StructType\CustLoyalty[] $custLoyalty
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $vendor
     * @param \rdyescapiacontent\StructType\ReservationTimeSpan $reservationTimeSpan
     * @param \rdyescapiacontent\StructType\AssociatedQuantity[] $associatedQuantity
     * @param \rdyescapiacontent\StructType\StartLocation $startLocation
     * @param \rdyescapiacontent\StructType\EndLocation $endLocation
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct(\rdyescapiacontent\StructType\PersonName $personName = null, \rdyescapiacontent\StructType\EmailType $email = null, \rdyescapiacontent\StructType\TelephoneInfo $telephoneInfo = null, \rdyescapiacontent\StructType\PaymentCardType $paymentCard = null, \rdyescapiacontent\StructType\AddressInfoType $addressInfo = null, array $custLoyalty = array(), array $vendor = array(), \rdyescapiacontent\StructType\ReservationTimeSpan $reservationTimeSpan = null, array $associatedQuantity = array(), \rdyescapiacontent\StructType\StartLocation $startLocation = null, \rdyescapiacontent\StructType\EndLocation $endLocation = null, \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setPersonName($personName)
            ->setEmail($email)
            ->setTelephoneInfo($telephoneInfo)
            ->setPaymentCard($paymentCard)
            ->setAddressInfo($addressInfo)
            ->setCustLoyalty($custLoyalty)
            ->setVendor($vendor)
            ->setReservationTimeSpan($reservationTimeSpan)
            ->setAssociatedQuantity($associatedQuantity)
            ->setStartLocation($startLocation)
            ->setEndLocation($endLocation)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get PersonName value
     * @return \rdyescapiacontent\StructType\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapiacontent\StructType\PersonName $personName
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setPersonName(\rdyescapiacontent\StructType\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapiacontent\StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \rdyescapiacontent\StructType\EmailType $email
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setEmail(\rdyescapiacontent\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \rdyescapiacontent\StructType\TelephoneInfo|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * Set TelephoneInfo value
     * @param \rdyescapiacontent\StructType\TelephoneInfo $telephoneInfo
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setTelephoneInfo(\rdyescapiacontent\StructType\TelephoneInfo $telephoneInfo = null)
    {
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \rdyescapiacontent\StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \rdyescapiacontent\StructType\PaymentCardType $paymentCard
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setPaymentCard(\rdyescapiacontent\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \rdyescapiacontent\StructType\AddressInfoType|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \rdyescapiacontent\StructType\AddressInfoType $addressInfo
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setAddressInfo(\rdyescapiacontent\StructType\AddressInfoType $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \rdyescapiacontent\StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$verificationTypeCustLoyaltyItem instanceof \rdyescapiacontent\StructType\CustLoyalty) {
                $invalidValues[] = is_object($verificationTypeCustLoyaltyItem) ? get_class($verificationTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($verificationTypeCustLoyaltyItem), var_export($verificationTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \rdyescapiacontent\StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CustLoyalty[] $custLoyalty
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CustLoyalty $item
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function addToCustLoyalty(\rdyescapiacontent\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \rdyescapiacontent\StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \rdyescapiacontent\StructType\CompanyNameType[]|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * This method is responsible for validating the values passed to the setVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorForArrayConstraintsFromSetVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeVendorItem) {
            // validation for constraint: itemType
            if (!$verificationTypeVendorItem instanceof \rdyescapiacontent\StructType\CompanyNameType) {
                $invalidValues[] = is_object($verificationTypeVendorItem) ? get_class($verificationTypeVendorItem) : sprintf('%s(%s)', gettype($verificationTypeVendorItem), var_export($verificationTypeVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vendor property can only contain items of type \rdyescapiacontent\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vendor value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $vendor
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setVendor(array $vendor = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorArrayErrorMessage = self::validateVendorForArrayConstraintsFromSetVendor($vendor))) {
            throw new \InvalidArgumentException($vendorArrayErrorMessage, __LINE__);
        }
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Add item to Vendor value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType $item
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function addToVendor(\rdyescapiacontent\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The Vendor property can only contain items of type \rdyescapiacontent\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vendor[] = $item;
        return $this;
    }
    /**
     * Get ReservationTimeSpan value
     * @return \rdyescapiacontent\StructType\ReservationTimeSpan|null
     */
    public function getReservationTimeSpan()
    {
        return $this->ReservationTimeSpan;
    }
    /**
     * Set ReservationTimeSpan value
     * @param \rdyescapiacontent\StructType\ReservationTimeSpan $reservationTimeSpan
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setReservationTimeSpan(\rdyescapiacontent\StructType\ReservationTimeSpan $reservationTimeSpan = null)
    {
        $this->ReservationTimeSpan = $reservationTimeSpan;
        return $this;
    }
    /**
     * Get AssociatedQuantity value
     * @return \rdyescapiacontent\StructType\AssociatedQuantity[]|null
     */
    public function getAssociatedQuantity()
    {
        return $this->AssociatedQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociatedQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociatedQuantityForArrayConstraintsFromSetAssociatedQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationTypeAssociatedQuantityItem) {
            // validation for constraint: itemType
            if (!$verificationTypeAssociatedQuantityItem instanceof \rdyescapiacontent\StructType\AssociatedQuantity) {
                $invalidValues[] = is_object($verificationTypeAssociatedQuantityItem) ? get_class($verificationTypeAssociatedQuantityItem) : sprintf('%s(%s)', gettype($verificationTypeAssociatedQuantityItem), var_export($verificationTypeAssociatedQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssociatedQuantity property can only contain items of type \rdyescapiacontent\StructType\AssociatedQuantity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AssociatedQuantity[] $associatedQuantity
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setAssociatedQuantity(array $associatedQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($associatedQuantityArrayErrorMessage = self::validateAssociatedQuantityForArrayConstraintsFromSetAssociatedQuantity($associatedQuantity))) {
            throw new \InvalidArgumentException($associatedQuantityArrayErrorMessage, __LINE__);
        }
        $this->AssociatedQuantity = $associatedQuantity;
        return $this;
    }
    /**
     * Add item to AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AssociatedQuantity $item
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function addToAssociatedQuantity(\rdyescapiacontent\StructType\AssociatedQuantity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AssociatedQuantity) {
            throw new \InvalidArgumentException(sprintf('The AssociatedQuantity property can only contain items of type \rdyescapiacontent\StructType\AssociatedQuantity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssociatedQuantity[] = $item;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return \rdyescapiacontent\StructType\StartLocation|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param \rdyescapiacontent\StructType\StartLocation $startLocation
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setStartLocation(\rdyescapiacontent\StructType\StartLocation $startLocation = null)
    {
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return \rdyescapiacontent\StructType\EndLocation|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param \rdyescapiacontent\StructType\EndLocation $endLocation
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setEndLocation(\rdyescapiacontent\StructType\EndLocation $endLocation = null)
    {
        $this->EndLocation = $endLocation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\VerificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
