<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehType StructType
 * @subpackage Structs
 */
class VehType extends AbstractStructBase
{
    /**
     * The VehicleCategory
     * @var string
     */
    public $VehicleCategory;
    /**
     * The DoorCount
     * @var string
     */
    public $DoorCount;
    /**
     * Constructor method for VehType
     * @uses VehType::setVehicleCategory()
     * @uses VehType::setDoorCount()
     * @param string $vehicleCategory
     * @param string $doorCount
     */
    public function __construct($vehicleCategory = null, $doorCount = null)
    {
        $this
            ->setVehicleCategory($vehicleCategory)
            ->setDoorCount($doorCount);
    }
    /**
     * Get VehicleCategory value
     * @return string|null
     */
    public function getVehicleCategory()
    {
        return $this->VehicleCategory;
    }
    /**
     * Set VehicleCategory value
     * @param string $vehicleCategory
     * @return \rdyescapiacontent\StructType\VehType
     */
    public function setVehicleCategory($vehicleCategory = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCategory) && !is_string($vehicleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleCategory, true), gettype($vehicleCategory)), __LINE__);
        }
        $this->VehicleCategory = $vehicleCategory;
        return $this;
    }
    /**
     * Get DoorCount value
     * @return string|null
     */
    public function getDoorCount()
    {
        return $this->DoorCount;
    }
    /**
     * Set DoorCount value
     * @param string $doorCount
     * @return \rdyescapiacontent\StructType\VehType
     */
    public function setDoorCount($doorCount = null)
    {
        // validation for constraint: string
        if (!is_null($doorCount) && !is_string($doorCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doorCount, true), gettype($doorCount)), __LINE__);
        }
        $this->DoorCount = $doorCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\VehType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
