<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * @subpackage Structs
 */
class MultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The ImageItems
     * Meta information extracted from the WSDL
     * - choice: ImageItems | TextItems | VideoItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ImageItemsType
     */
    public $ImageItems;
    /**
     * The TextItems
     * Meta information extracted from the WSDL
     * - choice: ImageItems | TextItems | VideoItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TextItemsType
     */
    public $TextItems;
    /**
     * The VideoItems
     * Meta information extracted from the WSDL
     * - choice: ImageItems | TextItems | VideoItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\VideoItems
     */
    public $VideoItems;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses MultimediaDescriptionType::setImageItems()
     * @uses MultimediaDescriptionType::setTextItems()
     * @uses MultimediaDescriptionType::setVideoItems()
     * @param \rdyescapiacontent\StructType\ImageItemsType $imageItems
     * @param \rdyescapiacontent\StructType\TextItemsType $textItems
     * @param \rdyescapiacontent\StructType\VideoItems $videoItems
     */
    public function __construct(\rdyescapiacontent\StructType\ImageItemsType $imageItems = null, \rdyescapiacontent\StructType\TextItemsType $textItems = null, \rdyescapiacontent\StructType\VideoItems $videoItems = null)
    {
        $this
            ->setImageItems($imageItems)
            ->setTextItems($textItems)
            ->setVideoItems($videoItems);
    }
    /**
     * Get ImageItems value
     * @return \rdyescapiacontent\StructType\ImageItemsType|null
     */
    public function getImageItems()
    {
        return isset($this->ImageItems) ? $this->ImageItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImageItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageItemsForChoiceConstraintsFromSetImageItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TextItems',
            'VideoItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ImageItems can\'t be set as the property %s is already set. Only one property must be set among these properties: ImageItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ImageItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ImageItemsType $imageItems
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionType
     */
    public function setImageItems(\rdyescapiacontent\StructType\ImageItemsType $imageItems = null)
    {
        // validation for constraint: choice(ImageItems, TextItems, VideoItems)
        if ('' !== ($imageItemsChoiceErrorMessage = self::validateImageItemsForChoiceConstraintsFromSetImageItems($imageItems))) {
            throw new \InvalidArgumentException($imageItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($imageItems) || (is_array($imageItems) && empty($imageItems))) {
            unset($this->ImageItems);
        } else {
            $this->ImageItems = $imageItems;
        }
        return $this;
    }
    /**
     * Get TextItems value
     * @return \rdyescapiacontent\StructType\TextItemsType|null
     */
    public function getTextItems()
    {
        return isset($this->TextItems) ? $this->TextItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTextItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextItemsForChoiceConstraintsFromSetTextItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ImageItems',
            'VideoItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TextItems can\'t be set as the property %s is already set. Only one property must be set among these properties: TextItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TextItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TextItemsType $textItems
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionType
     */
    public function setTextItems(\rdyescapiacontent\StructType\TextItemsType $textItems = null)
    {
        // validation for constraint: choice(ImageItems, TextItems, VideoItems)
        if ('' !== ($textItemsChoiceErrorMessage = self::validateTextItemsForChoiceConstraintsFromSetTextItems($textItems))) {
            throw new \InvalidArgumentException($textItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($textItems) || (is_array($textItems) && empty($textItems))) {
            unset($this->TextItems);
        } else {
            $this->TextItems = $textItems;
        }
        return $this;
    }
    /**
     * Get VideoItems value
     * @return \rdyescapiacontent\StructType\VideoItems|null
     */
    public function getVideoItems()
    {
        return isset($this->VideoItems) ? $this->VideoItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVideoItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVideoItemsForChoiceConstraintsFromSetVideoItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ImageItems',
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VideoItems can\'t be set as the property %s is already set. Only one property must be set among these properties: VideoItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VideoItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\VideoItems $videoItems
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionType
     */
    public function setVideoItems(\rdyescapiacontent\StructType\VideoItems $videoItems = null)
    {
        // validation for constraint: choice(ImageItems, TextItems, VideoItems)
        if ('' !== ($videoItemsChoiceErrorMessage = self::validateVideoItemsForChoiceConstraintsFromSetVideoItems($videoItems))) {
            throw new \InvalidArgumentException($videoItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($videoItems) || (is_array($videoItems) && empty($videoItems))) {
            unset($this->VideoItems);
        } else {
            $this->VideoItems = $videoItems;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
