<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Descriptions StructType
 * @subpackage Structs
 */
class Descriptions extends AbstractStructBase
{
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MultimediaDescriptions
     */
    public $MultimediaDescriptions;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The RateNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateNotes;
    /**
     * Constructor method for Descriptions
     * @uses Descriptions::setMultimediaDescriptions()
     * @uses Descriptions::setDescriptiveText()
     * @uses Descriptions::setRateNotes()
     * @param \rdyescapiacontent\StructType\MultimediaDescriptions $multimediaDescriptions
     * @param string $descriptiveText
     * @param string $rateNotes
     */
    public function __construct(\rdyescapiacontent\StructType\MultimediaDescriptions $multimediaDescriptions = null, $descriptiveText = null, $rateNotes = null)
    {
        $this
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setDescriptiveText($descriptiveText)
            ->setRateNotes($rateNotes);
    }
    /**
     * Get MultimediaDescriptions value
     * @return \rdyescapiacontent\StructType\MultimediaDescriptions|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \rdyescapiacontent\StructType\MultimediaDescriptions $multimediaDescriptions
     * @return \rdyescapiacontent\StructType\Descriptions
     */
    public function setMultimediaDescriptions(\rdyescapiacontent\StructType\MultimediaDescriptions $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \rdyescapiacontent\StructType\Descriptions
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get RateNotes value
     * @return string|null
     */
    public function getRateNotes()
    {
        return $this->RateNotes;
    }
    /**
     * Set RateNotes value
     * @param string $rateNotes
     * @return \rdyescapiacontent\StructType\Descriptions
     */
    public function setRateNotes($rateNotes = null)
    {
        // validation for constraint: string
        if (!is_null($rateNotes) && !is_string($rateNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateNotes, true), gettype($rateNotes)), __LINE__);
        }
        $this->RateNotes = $rateNotes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\Descriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
