<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyRedemption StructType
 * @subpackage Structs
 */
class LoyaltyRedemption extends AbstractStructBase
{
    /**
     * The CertificateNumber
     * @var string
     */
    public $CertificateNumber;
    /**
     * The MemberNumber
     * @var string
     */
    public $MemberNumber;
    /**
     * The ProgramName
     * @var string
     */
    public $ProgramName;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The RedemptionQuantity
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * Constructor method for LoyaltyRedemption
     * @uses LoyaltyRedemption::setCertificateNumber()
     * @uses LoyaltyRedemption::setMemberNumber()
     * @uses LoyaltyRedemption::setProgramName()
     * @uses LoyaltyRedemption::setPromotionCode()
     * @uses LoyaltyRedemption::setPromotionVendorCode()
     * @uses LoyaltyRedemption::setRedemptionQuantity()
     * @param string $certificateNumber
     * @param string $memberNumber
     * @param string $programName
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param int $redemptionQuantity
     */
    public function __construct($certificateNumber = null, $memberNumber = null, $programName = null, $promotionCode = null, array $promotionVendorCode = array(), $redemptionQuantity = null)
    {
        $this
            ->setCertificateNumber($certificateNumber)
            ->setMemberNumber($memberNumber)
            ->setProgramName($programName)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setRedemptionQuantity($redemptionQuantity);
    }
    /**
     * Get CertificateNumber value
     * @return string|null
     */
    public function getCertificateNumber()
    {
        return $this->CertificateNumber;
    }
    /**
     * Set CertificateNumber value
     * @param string $certificateNumber
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setCertificateNumber($certificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($certificateNumber) && !is_string($certificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificateNumber, true), gettype($certificateNumber)), __LINE__);
        }
        $this->CertificateNumber = $certificateNumber;
        return $this;
    }
    /**
     * Get MemberNumber value
     * @return string|null
     */
    public function getMemberNumber()
    {
        return $this->MemberNumber;
    }
    /**
     * Set MemberNumber value
     * @param string $memberNumber
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setMemberNumber($memberNumber = null)
    {
        // validation for constraint: string
        if (!is_null($memberNumber) && !is_string($memberNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberNumber, true), gettype($memberNumber)), __LINE__);
        }
        $this->MemberNumber = $memberNumber;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyRedemptionPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($loyaltyRedemptionPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($loyaltyRedemptionPromotionVendorCodeItem) ? get_class($loyaltyRedemptionPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($loyaltyRedemptionPromotionVendorCodeItem), var_export($loyaltyRedemptionPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $promotionVendorCode
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        $this->PromotionVendorCode = $promotionVendorCode;
        return $this;
    }
    /**
     * Add item to PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function addToPromotionVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PromotionVendorCode[] = $item;
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return $this->RedemptionQuantity;
    }
    /**
     * Set RedemptionQuantity value
     * @param int $redemptionQuantity
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantity) && !(is_int($redemptionQuantity) || ctype_digit($redemptionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantity, true), gettype($redemptionQuantity)), __LINE__);
        }
        $this->RedemptionQuantity = $redemptionQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
