<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoItem StructType
 * @subpackage Structs
 */
class VideoItem extends VideoDescriptionType
{
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Caption
     * @var string
     */
    public $Caption;
    /**
     * The Removal
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Removal;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * Constructor method for VideoItem
     * @uses VideoItem::setLanguage()
     * @uses VideoItem::setCaption()
     * @uses VideoItem::setRemoval()
     * @uses VideoItem::setVersion()
     * @uses VideoItem::setCreateDateTime()
     * @uses VideoItem::setCreatorID()
     * @uses VideoItem::setLastModifyDateTime()
     * @uses VideoItem::setLastModifierID()
     * @param string $language
     * @param string $caption
     * @param bool $removal
     * @param string $version
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     */
    public function __construct($language = null, $caption = null, $removal = false, $version = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null)
    {
        $this
            ->setLanguage($language)
            ->setCaption($caption)
            ->setRemoval($removal)
            ->setVersion($version)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setRemoval($removal = false)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\VideoItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
