<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItem StructType
 * @subpackage Structs
 */
class ImageItem extends ImageDescriptionType
{
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The Removal
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Removal;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The IsDefault
     * @var bool
     */
    public $IsDefault;
    /**
     * Constructor method for ImageItem
     * @uses ImageItem::setCreateDateTime()
     * @uses ImageItem::setCreatorID()
     * @uses ImageItem::setLastModifyDateTime()
     * @uses ImageItem::setLastModifierID()
     * @uses ImageItem::setRemoval()
     * @uses ImageItem::setVersion()
     * @uses ImageItem::setIsDefault()
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param bool $removal
     * @param string $version
     * @param bool $isDefault
     */
    public function __construct($createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $removal = false, $version = null, $isDefault = null)
    {
        $this
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setRemoval($removal)
            ->setVersion($version)
            ->setIsDefault($isDefault);
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setRemoval($removal = false)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ImageItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
