<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageFormat StructType
 * @subpackage Structs
 */
class ImageFormat extends ImageItemType
{
    /**
     * The ContentID
     * @var string
     */
    public $ContentID;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Author
     * @var string
     */
    public $Author;
    /**
     * The CopyrightNotice
     * @var string
     */
    public $CopyrightNotice;
    /**
     * The CopyrightOwner
     * @var string
     */
    public $CopyrightOwner;
    /**
     * The CopyrightStart
     * @var string
     */
    public $CopyrightStart;
    /**
     * The CopyrightEnd
     * @var string
     */
    public $CopyrightEnd;
    /**
     * The EffectiveStart
     * @var string
     */
    public $EffectiveStart;
    /**
     * The EffectiveEnd
     * @var string
     */
    public $EffectiveEnd;
    /**
     * The ApplicableStart
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The RecordID
     * @var string
     */
    public $RecordID;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Format
     * @var string
     */
    public $Format;
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The FileSize
     * @var int
     */
    public $FileSize;
    /**
     * The DimensionCategory
     * @var string
     */
    public $DimensionCategory;
    /**
     * The IsOriginalIndicator
     * @var bool
     */
    public $IsOriginalIndicator;
    /**
     * Constructor method for ImageFormat
     * @uses ImageFormat::setContentID()
     * @uses ImageFormat::setTitle()
     * @uses ImageFormat::setAuthor()
     * @uses ImageFormat::setCopyrightNotice()
     * @uses ImageFormat::setCopyrightOwner()
     * @uses ImageFormat::setCopyrightStart()
     * @uses ImageFormat::setCopyrightEnd()
     * @uses ImageFormat::setEffectiveStart()
     * @uses ImageFormat::setEffectiveEnd()
     * @uses ImageFormat::setApplicableStart()
     * @uses ImageFormat::setApplicableEnd()
     * @uses ImageFormat::setRecordID()
     * @uses ImageFormat::setLanguage()
     * @uses ImageFormat::setFormat()
     * @uses ImageFormat::setFileName()
     * @uses ImageFormat::setFileSize()
     * @uses ImageFormat::setDimensionCategory()
     * @uses ImageFormat::setIsOriginalIndicator()
     * @param string $contentID
     * @param string $title
     * @param string $author
     * @param string $copyrightNotice
     * @param string $copyrightOwner
     * @param string $copyrightStart
     * @param string $copyrightEnd
     * @param string $effectiveStart
     * @param string $effectiveEnd
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $recordID
     * @param string $language
     * @param string $format
     * @param string $fileName
     * @param int $fileSize
     * @param string $dimensionCategory
     * @param bool $isOriginalIndicator
     */
    public function __construct($contentID = null, $title = null, $author = null, $copyrightNotice = null, $copyrightOwner = null, $copyrightStart = null, $copyrightEnd = null, $effectiveStart = null, $effectiveEnd = null, $applicableStart = null, $applicableEnd = null, $recordID = null, $language = null, $format = null, $fileName = null, $fileSize = null, $dimensionCategory = null, $isOriginalIndicator = null)
    {
        $this
            ->setContentID($contentID)
            ->setTitle($title)
            ->setAuthor($author)
            ->setCopyrightNotice($copyrightNotice)
            ->setCopyrightOwner($copyrightOwner)
            ->setCopyrightStart($copyrightStart)
            ->setCopyrightEnd($copyrightEnd)
            ->setEffectiveStart($effectiveStart)
            ->setEffectiveEnd($effectiveEnd)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setRecordID($recordID)
            ->setLanguage($language)
            ->setFormat($format)
            ->setFileName($fileName)
            ->setFileSize($fileSize)
            ->setDimensionCategory($dimensionCategory)
            ->setIsOriginalIndicator($isOriginalIndicator);
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentID, true), gettype($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get CopyrightNotice value
     * @return string|null
     */
    public function getCopyrightNotice()
    {
        return $this->CopyrightNotice;
    }
    /**
     * Set CopyrightNotice value
     * @param string $copyrightNotice
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setCopyrightNotice($copyrightNotice = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightNotice) && !is_string($copyrightNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightNotice, true), gettype($copyrightNotice)), __LINE__);
        }
        $this->CopyrightNotice = $copyrightNotice;
        return $this;
    }
    /**
     * Get CopyrightOwner value
     * @return string|null
     */
    public function getCopyrightOwner()
    {
        return $this->CopyrightOwner;
    }
    /**
     * Set CopyrightOwner value
     * @param string $copyrightOwner
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setCopyrightOwner($copyrightOwner = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightOwner) && !is_string($copyrightOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightOwner, true), gettype($copyrightOwner)), __LINE__);
        }
        $this->CopyrightOwner = $copyrightOwner;
        return $this;
    }
    /**
     * Get CopyrightStart value
     * @return string|null
     */
    public function getCopyrightStart()
    {
        return $this->CopyrightStart;
    }
    /**
     * Set CopyrightStart value
     * @param string $copyrightStart
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setCopyrightStart($copyrightStart = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightStart) && !is_string($copyrightStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightStart, true), gettype($copyrightStart)), __LINE__);
        }
        $this->CopyrightStart = $copyrightStart;
        return $this;
    }
    /**
     * Get CopyrightEnd value
     * @return string|null
     */
    public function getCopyrightEnd()
    {
        return $this->CopyrightEnd;
    }
    /**
     * Set CopyrightEnd value
     * @param string $copyrightEnd
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setCopyrightEnd($copyrightEnd = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightEnd) && !is_string($copyrightEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightEnd, true), gettype($copyrightEnd)), __LINE__);
        }
        $this->CopyrightEnd = $copyrightEnd;
        return $this;
    }
    /**
     * Get EffectiveStart value
     * @return string|null
     */
    public function getEffectiveStart()
    {
        return $this->EffectiveStart;
    }
    /**
     * Set EffectiveStart value
     * @param string $effectiveStart
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setEffectiveStart($effectiveStart = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStart) && !is_string($effectiveStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStart, true), gettype($effectiveStart)), __LINE__);
        }
        $this->EffectiveStart = $effectiveStart;
        return $this;
    }
    /**
     * Get EffectiveEnd value
     * @return string|null
     */
    public function getEffectiveEnd()
    {
        return $this->EffectiveEnd;
    }
    /**
     * Set EffectiveEnd value
     * @param string $effectiveEnd
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setEffectiveEnd($effectiveEnd = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEnd) && !is_string($effectiveEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEnd, true), gettype($effectiveEnd)), __LINE__);
        }
        $this->EffectiveEnd = $effectiveEnd;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get DimensionCategory value
     * @return string|null
     */
    public function getDimensionCategory()
    {
        return $this->DimensionCategory;
    }
    /**
     * Set DimensionCategory value
     * @param string $dimensionCategory
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setDimensionCategory($dimensionCategory = null)
    {
        // validation for constraint: string
        if (!is_null($dimensionCategory) && !is_string($dimensionCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dimensionCategory, true), gettype($dimensionCategory)), __LINE__);
        }
        $this->DimensionCategory = $dimensionCategory;
        return $this;
    }
    /**
     * Get IsOriginalIndicator value
     * @return bool|null
     */
    public function getIsOriginalIndicator()
    {
        return $this->IsOriginalIndicator;
    }
    /**
     * Set IsOriginalIndicator value
     * @param bool $isOriginalIndicator
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public function setIsOriginalIndicator($isOriginalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOriginalIndicator) && !is_bool($isOriginalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOriginalIndicator, true), gettype($isOriginalIndicator)), __LINE__);
        }
        $this->IsOriginalIndicator = $isOriginalIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ImageFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
