<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTypePref StructType
 * @subpackage Structs
 */
class FlightTypePref extends AbstractStructBase
{
    /**
     * The FlightType
     * @var string
     */
    public $FlightType;
    /**
     * The MaxConnections
     * @var int
     */
    public $MaxConnections;
    /**
     * The NonScheduledFltInfo
     * @var string
     */
    public $NonScheduledFltInfo;
    /**
     * The BackhaulIndicator
     * @var bool
     */
    public $BackhaulIndicator;
    /**
     * The GroundTransportIndicator
     * @var bool
     */
    public $GroundTransportIndicator;
    /**
     * The DirectAndNonStopOnlyInd
     * @var bool
     */
    public $DirectAndNonStopOnlyInd;
    /**
     * The NonStopsOnlyInd
     * @var bool
     */
    public $NonStopsOnlyInd;
    /**
     * The OnlineConnectionsOnlyInd
     * @var bool
     */
    public $OnlineConnectionsOnlyInd;
    /**
     * The RoutingType
     * @var string
     */
    public $RoutingType;
    /**
     * Constructor method for FlightTypePref
     * @uses FlightTypePref::setFlightType()
     * @uses FlightTypePref::setMaxConnections()
     * @uses FlightTypePref::setNonScheduledFltInfo()
     * @uses FlightTypePref::setBackhaulIndicator()
     * @uses FlightTypePref::setGroundTransportIndicator()
     * @uses FlightTypePref::setDirectAndNonStopOnlyInd()
     * @uses FlightTypePref::setNonStopsOnlyInd()
     * @uses FlightTypePref::setOnlineConnectionsOnlyInd()
     * @uses FlightTypePref::setRoutingType()
     * @param string $flightType
     * @param int $maxConnections
     * @param string $nonScheduledFltInfo
     * @param bool $backhaulIndicator
     * @param bool $groundTransportIndicator
     * @param bool $directAndNonStopOnlyInd
     * @param bool $nonStopsOnlyInd
     * @param bool $onlineConnectionsOnlyInd
     * @param string $routingType
     */
    public function __construct($flightType = null, $maxConnections = null, $nonScheduledFltInfo = null, $backhaulIndicator = null, $groundTransportIndicator = null, $directAndNonStopOnlyInd = null, $nonStopsOnlyInd = null, $onlineConnectionsOnlyInd = null, $routingType = null)
    {
        $this
            ->setFlightType($flightType)
            ->setMaxConnections($maxConnections)
            ->setNonScheduledFltInfo($nonScheduledFltInfo)
            ->setBackhaulIndicator($backhaulIndicator)
            ->setGroundTransportIndicator($groundTransportIndicator)
            ->setDirectAndNonStopOnlyInd($directAndNonStopOnlyInd)
            ->setNonStopsOnlyInd($nonStopsOnlyInd)
            ->setOnlineConnectionsOnlyInd($onlineConnectionsOnlyInd)
            ->setRoutingType($routingType);
    }
    /**
     * Get FlightType value
     * @return string|null
     */
    public function getFlightType()
    {
        return $this->FlightType;
    }
    /**
     * Set FlightType value
     * @uses \rdyescapiacontent\EnumType\FlightTypeType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\FlightTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightType
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setFlightType($flightType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\FlightTypeType::valueIsValid($flightType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\FlightTypeType', is_array($flightType) ? implode(', ', $flightType) : var_export($flightType, true), implode(', ', \rdyescapiacontent\EnumType\FlightTypeType::getValidValues())), __LINE__);
        }
        $this->FlightType = $flightType;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return int|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param int $maxConnections
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setMaxConnections($maxConnections = null)
    {
        // validation for constraint: int
        if (!is_null($maxConnections) && !(is_int($maxConnections) || ctype_digit($maxConnections))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxConnections, true), gettype($maxConnections)), __LINE__);
        }
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get NonScheduledFltInfo value
     * @return string|null
     */
    public function getNonScheduledFltInfo()
    {
        return $this->NonScheduledFltInfo;
    }
    /**
     * Set NonScheduledFltInfo value
     * @param string $nonScheduledFltInfo
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setNonScheduledFltInfo($nonScheduledFltInfo = null)
    {
        // validation for constraint: string
        if (!is_null($nonScheduledFltInfo) && !is_string($nonScheduledFltInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonScheduledFltInfo, true), gettype($nonScheduledFltInfo)), __LINE__);
        }
        $this->NonScheduledFltInfo = $nonScheduledFltInfo;
        return $this;
    }
    /**
     * Get BackhaulIndicator value
     * @return bool|null
     */
    public function getBackhaulIndicator()
    {
        return $this->BackhaulIndicator;
    }
    /**
     * Set BackhaulIndicator value
     * @param bool $backhaulIndicator
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setBackhaulIndicator($backhaulIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($backhaulIndicator) && !is_bool($backhaulIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($backhaulIndicator, true), gettype($backhaulIndicator)), __LINE__);
        }
        $this->BackhaulIndicator = $backhaulIndicator;
        return $this;
    }
    /**
     * Get GroundTransportIndicator value
     * @return bool|null
     */
    public function getGroundTransportIndicator()
    {
        return $this->GroundTransportIndicator;
    }
    /**
     * Set GroundTransportIndicator value
     * @param bool $groundTransportIndicator
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setGroundTransportIndicator($groundTransportIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($groundTransportIndicator) && !is_bool($groundTransportIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groundTransportIndicator, true), gettype($groundTransportIndicator)), __LINE__);
        }
        $this->GroundTransportIndicator = $groundTransportIndicator;
        return $this;
    }
    /**
     * Get DirectAndNonStopOnlyInd value
     * @return bool|null
     */
    public function getDirectAndNonStopOnlyInd()
    {
        return $this->DirectAndNonStopOnlyInd;
    }
    /**
     * Set DirectAndNonStopOnlyInd value
     * @param bool $directAndNonStopOnlyInd
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setDirectAndNonStopOnlyInd($directAndNonStopOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($directAndNonStopOnlyInd) && !is_bool($directAndNonStopOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directAndNonStopOnlyInd, true), gettype($directAndNonStopOnlyInd)), __LINE__);
        }
        $this->DirectAndNonStopOnlyInd = $directAndNonStopOnlyInd;
        return $this;
    }
    /**
     * Get NonStopsOnlyInd value
     * @return bool|null
     */
    public function getNonStopsOnlyInd()
    {
        return $this->NonStopsOnlyInd;
    }
    /**
     * Set NonStopsOnlyInd value
     * @param bool $nonStopsOnlyInd
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setNonStopsOnlyInd($nonStopsOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonStopsOnlyInd) && !is_bool($nonStopsOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonStopsOnlyInd, true), gettype($nonStopsOnlyInd)), __LINE__);
        }
        $this->NonStopsOnlyInd = $nonStopsOnlyInd;
        return $this;
    }
    /**
     * Get OnlineConnectionsOnlyInd value
     * @return bool|null
     */
    public function getOnlineConnectionsOnlyInd()
    {
        return $this->OnlineConnectionsOnlyInd;
    }
    /**
     * Set OnlineConnectionsOnlyInd value
     * @param bool $onlineConnectionsOnlyInd
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setOnlineConnectionsOnlyInd($onlineConnectionsOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlineConnectionsOnlyInd) && !is_bool($onlineConnectionsOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlineConnectionsOnlyInd, true), gettype($onlineConnectionsOnlyInd)), __LINE__);
        }
        $this->OnlineConnectionsOnlyInd = $onlineConnectionsOnlyInd;
        return $this;
    }
    /**
     * Get RoutingType value
     * @return string|null
     */
    public function getRoutingType()
    {
        return $this->RoutingType;
    }
    /**
     * Set RoutingType value
     * @param string $routingType
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: string
        if (!is_null($routingType) && !is_string($routingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingType, true), gettype($routingType)), __LINE__);
        }
        $this->RoutingType = $routingType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\FlightTypePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
