<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedTravelerPrefType StructType
 * @subpackage Structs
 */
class RelatedTravelerPrefType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for RelatedTravelerPrefType
     * @uses RelatedTravelerPrefType::setUniqueID()
     * @uses RelatedTravelerPrefType::setPreferLevel()
     * @param \rdyescapiacontent\StructType\UniqueID_Type $uniqueID
     * @param string $preferLevel
     */
    public function __construct(\rdyescapiacontent\StructType\UniqueID_Type $uniqueID = null, $preferLevel = 'Preferred')
    {
        $this
            ->setUniqueID($uniqueID)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapiacontent\StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \rdyescapiacontent\StructType\UniqueID_Type $uniqueID
     * @return \rdyescapiacontent\StructType\RelatedTravelerPrefType
     */
    public function setUniqueID(\rdyescapiacontent\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapiacontent\StructType\RelatedTravelerPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\RelatedTravelerPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
