<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagerResponseType StructType
 * @subpackage Structs
 */
class ManagerResponseType extends AbstractStructBase
{
    /**
     * The ResponseDate
     * @var string
     */
    public $ResponseDate;
    /**
     * The ResponseTitle
     * @var string
     */
    public $ResponseTitle;
    /**
     * The Comment
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for ManagerResponseType
     * @uses ManagerResponseType::setResponseDate()
     * @uses ManagerResponseType::setResponseTitle()
     * @uses ManagerResponseType::setComment()
     * @param string $responseDate
     * @param string $responseTitle
     * @param string $comment
     */
    public function __construct($responseDate = null, $responseTitle = null, $comment = null)
    {
        $this
            ->setResponseDate($responseDate)
            ->setResponseTitle($responseTitle)
            ->setComment($comment);
    }
    /**
     * Get ResponseDate value
     * @return string|null
     */
    public function getResponseDate()
    {
        return $this->ResponseDate;
    }
    /**
     * Set ResponseDate value
     * @param string $responseDate
     * @return \rdyescapiacontent\StructType\ManagerResponseType
     */
    public function setResponseDate($responseDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDate) && !is_string($responseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDate, true), gettype($responseDate)), __LINE__);
        }
        $this->ResponseDate = $responseDate;
        return $this;
    }
    /**
     * Get ResponseTitle value
     * @return string|null
     */
    public function getResponseTitle()
    {
        return $this->ResponseTitle;
    }
    /**
     * Set ResponseTitle value
     * @param string $responseTitle
     * @return \rdyescapiacontent\StructType\ManagerResponseType
     */
    public function setResponseTitle($responseTitle = null)
    {
        // validation for constraint: string
        if (!is_null($responseTitle) && !is_string($responseTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseTitle, true), gettype($responseTitle)), __LINE__);
        }
        $this->ResponseTitle = $responseTitle;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \rdyescapiacontent\StructType\ManagerResponseType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ManagerResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
