<?php

namespace rdyescapiacontent\EnumType;

/**
 * This class stands for PetsAllowedCodeType EnumType
 * @subpackage Enumerations
 */
class PetsAllowedCodeType
{
    /**
     * Constant for value 'Pets Allowed'
     * @return string 'Pets Allowed'
     */
    const VALUE_PETS_ALLOWED = 'Pets Allowed';
    /**
     * Constant for value 'Pets Not Allowed'
     * @return string 'Pets Not Allowed'
     */
    const VALUE_PETS_NOT_ALLOWED = 'Pets Not Allowed';
    /**
     * Constant for value 'Assistive Animals Only'
     * @return string 'Assistive Animals Only'
     */
    const VALUE_ASSISTIVE_ANIMALS_ONLY = 'Assistive Animals Only';
    /**
     * Constant for value 'Pets By Arrangements'
     * @return string 'Pets By Arrangements'
     */
    const VALUE_PETS_BY_ARRANGEMENTS = 'Pets By Arrangements';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PETS_ALLOWED
     * @uses self::VALUE_PETS_NOT_ALLOWED
     * @uses self::VALUE_ASSISTIVE_ANIMALS_ONLY
     * @uses self::VALUE_PETS_BY_ARRANGEMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PETS_ALLOWED,
            self::VALUE_PETS_NOT_ALLOWED,
            self::VALUE_ASSISTIVE_ANIMALS_ONLY,
            self::VALUE_PETS_BY_ARRANGEMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
