<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResResponseType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class UnitResResponseType extends EVRN_BaseRSType
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Warnings | Errors | Success | UnitReservations
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Warnings | Errors | Success | UnitReservations
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Warnings | Errors | Success | UnitReservations
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SuccessType
     */
    public $Success;
    /**
     * The UnitReservations
     * Meta information extracted from the WSDL
     * - choice: Warnings | Errors | Success | UnitReservations
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for UnitResResponseType
     * @uses UnitResResponseType::setPOS()
     * @uses UnitResResponseType::setWarnings()
     * @uses UnitResResponseType::setErrors()
     * @uses UnitResResponseType::setSuccess()
     * @uses UnitResResponseType::setUnitReservations()
     * @uses UnitResResponseType::setResResponseType()
     * @param \rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS
     * @param \rdyescapiacontent\StructType\WarningsType $warnings
     * @param \rdyescapiacontent\StructType\ErrorsType $errors
     * @param \rdyescapiacontent\StructType\SuccessType $success
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @param string $resResponseType
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS = null, \rdyescapiacontent\StructType\WarningsType $warnings = null, \rdyescapiacontent\StructType\ErrorsType $errors = null, \rdyescapiacontent\StructType\SuccessType $success = null, \rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setUnitReservations($unitReservations)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return \rdyescapiacontent\ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setPOS(\rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \rdyescapiacontent\StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'Success',
            'UnitReservations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\WarningsType $warnings
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setWarnings(\rdyescapiacontent\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Warnings, Errors, Success, UnitReservations)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \rdyescapiacontent\StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Success',
            'UnitReservations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ErrorsType $errors
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setErrors(\rdyescapiacontent\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Warnings, Errors, Success, UnitReservations)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return \rdyescapiacontent\StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Errors',
            'UnitReservations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\SuccessType $success
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setSuccess(\rdyescapiacontent\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Warnings, Errors, Success, UnitReservations)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapiacontent\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return isset($this->UnitReservations) ? $this->UnitReservations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUnitReservations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitReservations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUnitReservationsForChoiceConstraintsFromSetUnitReservations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'Errors',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UnitReservations can\'t be set as the property %s is already set. Only one property must be set among these properties: UnitReservations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UnitReservations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setUnitReservations(\rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null)
    {
        // validation for constraint: choice(Warnings, Errors, Success, UnitReservations)
        if ('' !== ($unitReservationsChoiceErrorMessage = self::validateUnitReservationsForChoiceConstraintsFromSetUnitReservations($unitReservations))) {
            throw new \InvalidArgumentException($unitReservationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($unitReservations) || (is_array($unitReservations) && empty($unitReservations))) {
            unset($this->UnitReservations);
        } else {
            $this->UnitReservations = $unitReservations;
        }
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \rdyescapiacontent\EnumType\TransactionStatusType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\TransactionStatusType', is_array($resResponseType) ? implode(', ', $resResponseType) : var_export($resResponseType, true), implode(', ', \rdyescapiacontent\EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
