<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitInfoType StructType
 * @subpackage Structs
 */
class UnitInfoType extends AbstractStructBase
{
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitName
     */
    public $UnitName;
    /**
     * The CategoryCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EVRN_CategoryCodesType
     */
    public $CategoryCodes;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Descriptions
     */
    public $Descriptions;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Position
     */
    public $Position;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService
     */
    public $Services;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AddressType
     */
    public $Address;
    /**
     * The UnitAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitAmenityType[]
     */
    public $UnitAmenity;
    /**
     * The RateRanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfRateRangeType
     */
    public $RateRanges;
    /**
     * The AreaSquareFeet
     * @var float
     */
    public $AreaSquareFeet;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The NumberFloors
     * @var int
     */
    public $NumberFloors;
    /**
     * The WhenBuilt
     * @var string
     */
    public $WhenBuilt;
    /**
     * The LastUpdated
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for UnitInfoType
     * @uses UnitInfoType::setUnitName()
     * @uses UnitInfoType::setCategoryCodes()
     * @uses UnitInfoType::setDescriptions()
     * @uses UnitInfoType::setPosition()
     * @uses UnitInfoType::setServices()
     * @uses UnitInfoType::setAddress()
     * @uses UnitInfoType::setUnitAmenity()
     * @uses UnitInfoType::setRateRanges()
     * @uses UnitInfoType::setAreaSquareFeet()
     * @uses UnitInfoType::setMaxOccupancy()
     * @uses UnitInfoType::setNumberFloors()
     * @uses UnitInfoType::setWhenBuilt()
     * @uses UnitInfoType::setLastUpdated()
     * @param \rdyescapiacontent\StructType\UnitName $unitName
     * @param \rdyescapiacontent\StructType\EVRN_CategoryCodesType $categoryCodes
     * @param \rdyescapiacontent\StructType\Descriptions $descriptions
     * @param \rdyescapiacontent\StructType\Position $position
     * @param \rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService $services
     * @param \rdyescapiacontent\StructType\AddressType $address
     * @param \rdyescapiacontent\StructType\UnitAmenityType[] $unitAmenity
     * @param \rdyescapiacontent\ArrayType\ArrayOfRateRangeType $rateRanges
     * @param float $areaSquareFeet
     * @param int $maxOccupancy
     * @param int $numberFloors
     * @param string $whenBuilt
     * @param string $lastUpdated
     */
    public function __construct(\rdyescapiacontent\StructType\UnitName $unitName = null, \rdyescapiacontent\StructType\EVRN_CategoryCodesType $categoryCodes = null, \rdyescapiacontent\StructType\Descriptions $descriptions = null, \rdyescapiacontent\StructType\Position $position = null, \rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService $services = null, \rdyescapiacontent\StructType\AddressType $address = null, array $unitAmenity = array(), \rdyescapiacontent\ArrayType\ArrayOfRateRangeType $rateRanges = null, $areaSquareFeet = null, $maxOccupancy = null, $numberFloors = null, $whenBuilt = null, $lastUpdated = null)
    {
        $this
            ->setUnitName($unitName)
            ->setCategoryCodes($categoryCodes)
            ->setDescriptions($descriptions)
            ->setPosition($position)
            ->setServices($services)
            ->setAddress($address)
            ->setUnitAmenity($unitAmenity)
            ->setRateRanges($rateRanges)
            ->setAreaSquareFeet($areaSquareFeet)
            ->setMaxOccupancy($maxOccupancy)
            ->setNumberFloors($numberFloors)
            ->setWhenBuilt($whenBuilt)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get UnitName value
     * @return \rdyescapiacontent\StructType\UnitName|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param \rdyescapiacontent\StructType\UnitName $unitName
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setUnitName(\rdyescapiacontent\StructType\UnitName $unitName = null)
    {
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get CategoryCodes value
     * @return \rdyescapiacontent\StructType\EVRN_CategoryCodesType|null
     */
    public function getCategoryCodes()
    {
        return $this->CategoryCodes;
    }
    /**
     * Set CategoryCodes value
     * @param \rdyescapiacontent\StructType\EVRN_CategoryCodesType $categoryCodes
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setCategoryCodes(\rdyescapiacontent\StructType\EVRN_CategoryCodesType $categoryCodes = null)
    {
        $this->CategoryCodes = $categoryCodes;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \rdyescapiacontent\StructType\Descriptions|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \rdyescapiacontent\StructType\Descriptions $descriptions
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setDescriptions(\rdyescapiacontent\StructType\Descriptions $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Position value
     * @return \rdyescapiacontent\StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \rdyescapiacontent\StructType\Position $position
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setPosition(\rdyescapiacontent\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Services value
     * @return \rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService $services
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setServices(\rdyescapiacontent\ArrayType\ArrayOfUnitInfoTypeService $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapiacontent\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \rdyescapiacontent\StructType\AddressType $address
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setAddress(\rdyescapiacontent\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UnitAmenity value
     * @return \rdyescapiacontent\StructType\UnitAmenityType[]|null
     */
    public function getUnitAmenity()
    {
        return $this->UnitAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitAmenityForArrayConstraintsFromSetUnitAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitInfoTypeUnitAmenityItem) {
            // validation for constraint: itemType
            if (!$unitInfoTypeUnitAmenityItem instanceof \rdyescapiacontent\StructType\UnitAmenityType) {
                $invalidValues[] = is_object($unitInfoTypeUnitAmenityItem) ? get_class($unitInfoTypeUnitAmenityItem) : sprintf('%s(%s)', gettype($unitInfoTypeUnitAmenityItem), var_export($unitInfoTypeUnitAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitAmenity property can only contain items of type \rdyescapiacontent\StructType\UnitAmenityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitAmenityType[] $unitAmenity
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setUnitAmenity(array $unitAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($unitAmenityArrayErrorMessage = self::validateUnitAmenityForArrayConstraintsFromSetUnitAmenity($unitAmenity))) {
            throw new \InvalidArgumentException($unitAmenityArrayErrorMessage, __LINE__);
        }
        $this->UnitAmenity = $unitAmenity;
        return $this;
    }
    /**
     * Add item to UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitAmenityType $item
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function addToUnitAmenity(\rdyescapiacontent\StructType\UnitAmenityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UnitAmenityType) {
            throw new \InvalidArgumentException(sprintf('The UnitAmenity property can only contain items of type \rdyescapiacontent\StructType\UnitAmenityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitAmenity[] = $item;
        return $this;
    }
    /**
     * Get RateRanges value
     * @return \rdyescapiacontent\ArrayType\ArrayOfRateRangeType|null
     */
    public function getRateRanges()
    {
        return $this->RateRanges;
    }
    /**
     * Set RateRanges value
     * @param \rdyescapiacontent\ArrayType\ArrayOfRateRangeType $rateRanges
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setRateRanges(\rdyescapiacontent\ArrayType\ArrayOfRateRangeType $rateRanges = null)
    {
        $this->RateRanges = $rateRanges;
        return $this;
    }
    /**
     * Get AreaSquareFeet value
     * @return float|null
     */
    public function getAreaSquareFeet()
    {
        return $this->AreaSquareFeet;
    }
    /**
     * Set AreaSquareFeet value
     * @param float $areaSquareFeet
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setAreaSquareFeet($areaSquareFeet = null)
    {
        // validation for constraint: float
        if (!is_null($areaSquareFeet) && !(is_float($areaSquareFeet) || is_numeric($areaSquareFeet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($areaSquareFeet, true), gettype($areaSquareFeet)), __LINE__);
        }
        $this->AreaSquareFeet = $areaSquareFeet;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get NumberFloors value
     * @return int|null
     */
    public function getNumberFloors()
    {
        return $this->NumberFloors;
    }
    /**
     * Set NumberFloors value
     * @param int $numberFloors
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setNumberFloors($numberFloors = null)
    {
        // validation for constraint: int
        if (!is_null($numberFloors) && !(is_int($numberFloors) || ctype_digit($numberFloors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberFloors, true), gettype($numberFloors)), __LINE__);
        }
        $this->NumberFloors = $numberFloors;
        return $this;
    }
    /**
     * Get WhenBuilt value
     * @return string|null
     */
    public function getWhenBuilt()
    {
        return $this->WhenBuilt;
    }
    /**
     * Set WhenBuilt value
     * @param string $whenBuilt
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setWhenBuilt($whenBuilt = null)
    {
        // validation for constraint: string
        if (!is_null($whenBuilt) && !is_string($whenBuilt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whenBuilt, true), gettype($whenBuilt)), __LINE__);
        }
        $this->WhenBuilt = $whenBuilt;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
