<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextDescriptionType StructType
 * @subpackage Structs
 */
class TextDescriptionType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - choice: Description | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Description
     */
    public $Description;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - choice: Description | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The ContentID
     * @var string
     */
    public $ContentID;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Author
     * @var string
     */
    public $Author;
    /**
     * The CopyrightNotice
     * @var string
     */
    public $CopyrightNotice;
    /**
     * The CopyrightOwner
     * @var string
     */
    public $CopyrightOwner;
    /**
     * The CopyrightStart
     * @var string
     */
    public $CopyrightStart;
    /**
     * The CopyrightEnd
     * @var string
     */
    public $CopyrightEnd;
    /**
     * The EffectiveStart
     * @var string
     */
    public $EffectiveStart;
    /**
     * The EffectiveEnd
     * @var string
     */
    public $EffectiveEnd;
    /**
     * The ApplicableStart
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The RecordID
     * @var string
     */
    public $RecordID;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for TextDescriptionType
     * @uses TextDescriptionType::setDescription()
     * @uses TextDescriptionType::setURL()
     * @uses TextDescriptionType::setCategory()
     * @uses TextDescriptionType::setContentID()
     * @uses TextDescriptionType::setTitle()
     * @uses TextDescriptionType::setAuthor()
     * @uses TextDescriptionType::setCopyrightNotice()
     * @uses TextDescriptionType::setCopyrightOwner()
     * @uses TextDescriptionType::setCopyrightStart()
     * @uses TextDescriptionType::setCopyrightEnd()
     * @uses TextDescriptionType::setEffectiveStart()
     * @uses TextDescriptionType::setEffectiveEnd()
     * @uses TextDescriptionType::setApplicableStart()
     * @uses TextDescriptionType::setApplicableEnd()
     * @uses TextDescriptionType::setRecordID()
     * @uses TextDescriptionType::setLanguage()
     * @param \rdyescapiacontent\StructType\Description $description
     * @param string $uRL
     * @param string $category
     * @param string $contentID
     * @param string $title
     * @param string $author
     * @param string $copyrightNotice
     * @param string $copyrightOwner
     * @param string $copyrightStart
     * @param string $copyrightEnd
     * @param string $effectiveStart
     * @param string $effectiveEnd
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $recordID
     * @param string $language
     */
    public function __construct(\rdyescapiacontent\StructType\Description $description = null, $uRL = null, $category = null, $contentID = null, $title = null, $author = null, $copyrightNotice = null, $copyrightOwner = null, $copyrightStart = null, $copyrightEnd = null, $effectiveStart = null, $effectiveEnd = null, $applicableStart = null, $applicableEnd = null, $recordID = null, $language = null)
    {
        $this
            ->setDescription($description)
            ->setURL($uRL)
            ->setCategory($category)
            ->setContentID($contentID)
            ->setTitle($title)
            ->setAuthor($author)
            ->setCopyrightNotice($copyrightNotice)
            ->setCopyrightOwner($copyrightOwner)
            ->setCopyrightStart($copyrightStart)
            ->setCopyrightEnd($copyrightEnd)
            ->setEffectiveStart($effectiveStart)
            ->setEffectiveEnd($effectiveEnd)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setRecordID($recordID)
            ->setLanguage($language);
    }
    /**
     * Get Description value
     * @return \rdyescapiacontent\StructType\Description|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDescriptionForChoiceConstraintsFromSetDescription($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Description can\'t be set as the property %s is already set. Only one property must be set among these properties: Description, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Description value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Description $description
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setDescription(\rdyescapiacontent\StructType\Description $description = null)
    {
        // validation for constraint: choice(Description, URL)
        if ('' !== ($descriptionChoiceErrorMessage = self::validateDescriptionForChoiceConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Description',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(Description, URL)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentID, true), gettype($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get CopyrightNotice value
     * @return string|null
     */
    public function getCopyrightNotice()
    {
        return $this->CopyrightNotice;
    }
    /**
     * Set CopyrightNotice value
     * @param string $copyrightNotice
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setCopyrightNotice($copyrightNotice = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightNotice) && !is_string($copyrightNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightNotice, true), gettype($copyrightNotice)), __LINE__);
        }
        $this->CopyrightNotice = $copyrightNotice;
        return $this;
    }
    /**
     * Get CopyrightOwner value
     * @return string|null
     */
    public function getCopyrightOwner()
    {
        return $this->CopyrightOwner;
    }
    /**
     * Set CopyrightOwner value
     * @param string $copyrightOwner
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setCopyrightOwner($copyrightOwner = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightOwner) && !is_string($copyrightOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightOwner, true), gettype($copyrightOwner)), __LINE__);
        }
        $this->CopyrightOwner = $copyrightOwner;
        return $this;
    }
    /**
     * Get CopyrightStart value
     * @return string|null
     */
    public function getCopyrightStart()
    {
        return $this->CopyrightStart;
    }
    /**
     * Set CopyrightStart value
     * @param string $copyrightStart
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setCopyrightStart($copyrightStart = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightStart) && !is_string($copyrightStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightStart, true), gettype($copyrightStart)), __LINE__);
        }
        $this->CopyrightStart = $copyrightStart;
        return $this;
    }
    /**
     * Get CopyrightEnd value
     * @return string|null
     */
    public function getCopyrightEnd()
    {
        return $this->CopyrightEnd;
    }
    /**
     * Set CopyrightEnd value
     * @param string $copyrightEnd
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setCopyrightEnd($copyrightEnd = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightEnd) && !is_string($copyrightEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightEnd, true), gettype($copyrightEnd)), __LINE__);
        }
        $this->CopyrightEnd = $copyrightEnd;
        return $this;
    }
    /**
     * Get EffectiveStart value
     * @return string|null
     */
    public function getEffectiveStart()
    {
        return $this->EffectiveStart;
    }
    /**
     * Set EffectiveStart value
     * @param string $effectiveStart
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setEffectiveStart($effectiveStart = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStart) && !is_string($effectiveStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStart, true), gettype($effectiveStart)), __LINE__);
        }
        $this->EffectiveStart = $effectiveStart;
        return $this;
    }
    /**
     * Get EffectiveEnd value
     * @return string|null
     */
    public function getEffectiveEnd()
    {
        return $this->EffectiveEnd;
    }
    /**
     * Set EffectiveEnd value
     * @param string $effectiveEnd
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setEffectiveEnd($effectiveEnd = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEnd) && !is_string($effectiveEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEnd, true), gettype($effectiveEnd)), __LINE__);
        }
        $this->EffectiveEnd = $effectiveEnd;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\TextDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
