<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAreaType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class SearchAreaType extends AreaType
{
    /**
     * The UnitCount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitCount[]
     */
    public $UnitCount;
    /**
     * The ZipList
     * @var string[]
     */
    public $ZipList;
    /**
     * The MinDiscount
     * @var float
     */
    public $MinDiscount;
    /**
     * The MaxDiscount
     * @var float
     */
    public $MaxDiscount;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for SearchAreaType
     * @uses SearchAreaType::setUnitCount()
     * @uses SearchAreaType::setZipList()
     * @uses SearchAreaType::setMinDiscount()
     * @uses SearchAreaType::setMaxDiscount()
     * @uses SearchAreaType::setStartDate()
     * @uses SearchAreaType::setEndDate()
     * @param \rdyescapiacontent\StructType\UnitCount[] $unitCount
     * @param string[] $zipList
     * @param float $minDiscount
     * @param float $maxDiscount
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(array $unitCount = array(), array $zipList = array(), $minDiscount = null, $maxDiscount = null, $startDate = null, $endDate = null)
    {
        $this
            ->setUnitCount($unitCount)
            ->setZipList($zipList)
            ->setMinDiscount($minDiscount)
            ->setMaxDiscount($maxDiscount)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get UnitCount value
     * @return \rdyescapiacontent\StructType\UnitCount[]|null
     */
    public function getUnitCount()
    {
        return $this->UnitCount;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitCountForArrayConstraintsFromSetUnitCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchAreaTypeUnitCountItem) {
            // validation for constraint: itemType
            if (!$searchAreaTypeUnitCountItem instanceof \rdyescapiacontent\StructType\UnitCount) {
                $invalidValues[] = is_object($searchAreaTypeUnitCountItem) ? get_class($searchAreaTypeUnitCountItem) : sprintf('%s(%s)', gettype($searchAreaTypeUnitCountItem), var_export($searchAreaTypeUnitCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitCount property can only contain items of type \rdyescapiacontent\StructType\UnitCount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitCount[] $unitCount
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setUnitCount(array $unitCount = array())
    {
        // validation for constraint: array
        if ('' !== ($unitCountArrayErrorMessage = self::validateUnitCountForArrayConstraintsFromSetUnitCount($unitCount))) {
            throw new \InvalidArgumentException($unitCountArrayErrorMessage, __LINE__);
        }
        $this->UnitCount = $unitCount;
        return $this;
    }
    /**
     * Add item to UnitCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitCount $item
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function addToUnitCount(\rdyescapiacontent\StructType\UnitCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UnitCount) {
            throw new \InvalidArgumentException(sprintf('The UnitCount property can only contain items of type \rdyescapiacontent\StructType\UnitCount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitCount[] = $item;
        return $this;
    }
    /**
     * Get ZipList value
     * @return string[]|null
     */
    public function getZipList()
    {
        return $this->ZipList;
    }
    /**
     * This method is responsible for validating the values passed to the setZipList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZipList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipListForArrayConstraintsFromSetZipList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchAreaTypeZipListItem) {
            // validation for constraint: itemType
            if (!is_string($searchAreaTypeZipListItem)) {
                $invalidValues[] = is_object($searchAreaTypeZipListItem) ? get_class($searchAreaTypeZipListItem) : sprintf('%s(%s)', gettype($searchAreaTypeZipListItem), var_export($searchAreaTypeZipListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZipList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZipList value
     * @throws \InvalidArgumentException
     * @param string[] $zipList
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setZipList(array $zipList = array())
    {
        // validation for constraint: array
        if ('' !== ($zipListArrayErrorMessage = self::validateZipListForArrayConstraintsFromSetZipList($zipList))) {
            throw new \InvalidArgumentException($zipListArrayErrorMessage, __LINE__);
        }
        $this->ZipList = $zipList;
        return $this;
    }
    /**
     * Add item to ZipList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function addToZipList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ZipList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZipList[] = $item;
        return $this;
    }
    /**
     * Get MinDiscount value
     * @return float|null
     */
    public function getMinDiscount()
    {
        return $this->MinDiscount;
    }
    /**
     * Set MinDiscount value
     * @param float $minDiscount
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setMinDiscount($minDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($minDiscount) && !(is_float($minDiscount) || is_numeric($minDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minDiscount, true), gettype($minDiscount)), __LINE__);
        }
        $this->MinDiscount = $minDiscount;
        return $this;
    }
    /**
     * Get MaxDiscount value
     * @return float|null
     */
    public function getMaxDiscount()
    {
        return $this->MaxDiscount;
    }
    /**
     * Set MaxDiscount value
     * @param float $maxDiscount
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setMaxDiscount($maxDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($maxDiscount) && !(is_float($maxDiscount) || is_numeric($maxDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDiscount, true), gettype($maxDiscount)), __LINE__);
        }
        $this->MaxDiscount = $maxDiscount;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\SearchAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
