<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType StructType
 * @subpackage Structs
 */
class PaymentFormType extends AbstractStructBase
{
    /**
     * The MiscChargeOrder
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The LoyaltyRedemption
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The DirectBill
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The BankAcct
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\BankAcctType
     */
    public $BankAcct;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Voucher
     */
    public $Voucher;
    /**
     * The Cash
     * Meta information extracted from the WSDL
     * - choice: MiscChargeOrder | LoyaltyRedemption | PaymentCard | DirectBill | BankAcct | Voucher | Cash
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Cash
     */
    public $Cash;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CostCenterID
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * Constructor method for PaymentFormType
     * @uses PaymentFormType::setMiscChargeOrder()
     * @uses PaymentFormType::setLoyaltyRedemption()
     * @uses PaymentFormType::setPaymentCard()
     * @uses PaymentFormType::setDirectBill()
     * @uses PaymentFormType::setBankAcct()
     * @uses PaymentFormType::setVoucher()
     * @uses PaymentFormType::setCash()
     * @uses PaymentFormType::setShareSynchInd()
     * @uses PaymentFormType::setShareMarketInd()
     * @uses PaymentFormType::setCostCenterID()
     * @uses PaymentFormType::setRPH()
     * @uses PaymentFormType::setPaymentTransactionTypeCode()
     * @param \rdyescapiacontent\StructType\MiscChargeOrder $miscChargeOrder
     * @param \rdyescapiacontent\StructType\LoyaltyRedemption $loyaltyRedemption
     * @param \rdyescapiacontent\StructType\PaymentCardType $paymentCard
     * @param \rdyescapiacontent\StructType\DirectBillType $directBill
     * @param \rdyescapiacontent\StructType\BankAcctType $bankAcct
     * @param \rdyescapiacontent\StructType\Voucher $voucher
     * @param \rdyescapiacontent\StructType\Cash $cash
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     */
    public function __construct(\rdyescapiacontent\StructType\MiscChargeOrder $miscChargeOrder = null, \rdyescapiacontent\StructType\LoyaltyRedemption $loyaltyRedemption = null, \rdyescapiacontent\StructType\PaymentCardType $paymentCard = null, \rdyescapiacontent\StructType\DirectBillType $directBill = null, \rdyescapiacontent\StructType\BankAcctType $bankAcct = null, \rdyescapiacontent\StructType\Voucher $voucher = null, \rdyescapiacontent\StructType\Cash $cash = null, $shareSynchInd = null, $shareMarketInd = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null)
    {
        $this
            ->setMiscChargeOrder($miscChargeOrder)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setPaymentCard($paymentCard)
            ->setDirectBill($directBill)
            ->setBankAcct($bankAcct)
            ->setVoucher($voucher)
            ->setCash($cash)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode);
    }
    /**
     * Get MiscChargeOrder value
     * @return \rdyescapiacontent\StructType\MiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return isset($this->MiscChargeOrder) ? $this->MiscChargeOrder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMiscChargeOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiscChargeOrder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMiscChargeOrderForChoiceConstraintsFromSetMiscChargeOrder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'LoyaltyRedemption',
            'PaymentCard',
            'DirectBill',
            'BankAcct',
            'Voucher',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MiscChargeOrder can\'t be set as the property %s is already set. Only one property must be set among these properties: MiscChargeOrder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MiscChargeOrder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\MiscChargeOrder $miscChargeOrder
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setMiscChargeOrder(\rdyescapiacontent\StructType\MiscChargeOrder $miscChargeOrder = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($miscChargeOrderChoiceErrorMessage = self::validateMiscChargeOrderForChoiceConstraintsFromSetMiscChargeOrder($miscChargeOrder))) {
            throw new \InvalidArgumentException($miscChargeOrderChoiceErrorMessage, __LINE__);
        }
        if (is_null($miscChargeOrder) || (is_array($miscChargeOrder) && empty($miscChargeOrder))) {
            unset($this->MiscChargeOrder);
        } else {
            $this->MiscChargeOrder = $miscChargeOrder;
        }
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \rdyescapiacontent\StructType\LoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return isset($this->LoyaltyRedemption) ? $this->LoyaltyRedemption : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoyaltyRedemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyRedemption method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'PaymentCard',
            'DirectBill',
            'BankAcct',
            'Voucher',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoyaltyRedemption can\'t be set as the property %s is already set. Only one property must be set among these properties: LoyaltyRedemption, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoyaltyRedemption value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyRedemption $loyaltyRedemption
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setLoyaltyRedemption(\rdyescapiacontent\StructType\LoyaltyRedemption $loyaltyRedemption = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($loyaltyRedemptionChoiceErrorMessage = self::validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($loyaltyRedemption))) {
            throw new \InvalidArgumentException($loyaltyRedemptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($loyaltyRedemption) || (is_array($loyaltyRedemption) && empty($loyaltyRedemption))) {
            unset($this->LoyaltyRedemption);
        } else {
            $this->LoyaltyRedemption = $loyaltyRedemption;
        }
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \rdyescapiacontent\StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return isset($this->PaymentCard) ? $this->PaymentCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentCardForChoiceConstraintsFromSetPaymentCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'LoyaltyRedemption',
            'DirectBill',
            'BankAcct',
            'Voucher',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentCard can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentCardType $paymentCard
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setPaymentCard(\rdyescapiacontent\StructType\PaymentCardType $paymentCard = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($paymentCardChoiceErrorMessage = self::validatePaymentCardForChoiceConstraintsFromSetPaymentCard($paymentCard))) {
            throw new \InvalidArgumentException($paymentCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentCard) || (is_array($paymentCard) && empty($paymentCard))) {
            unset($this->PaymentCard);
        } else {
            $this->PaymentCard = $paymentCard;
        }
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \rdyescapiacontent\StructType\DirectBillType|null
     */
    public function getDirectBill()
    {
        return isset($this->DirectBill) ? $this->DirectBill : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectBill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectBill method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectBillForChoiceConstraintsFromSetDirectBill($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'LoyaltyRedemption',
            'PaymentCard',
            'BankAcct',
            'Voucher',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DirectBill can\'t be set as the property %s is already set. Only one property must be set among these properties: DirectBill, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DirectBill value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\DirectBillType $directBill
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setDirectBill(\rdyescapiacontent\StructType\DirectBillType $directBill = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($directBillChoiceErrorMessage = self::validateDirectBillForChoiceConstraintsFromSetDirectBill($directBill))) {
            throw new \InvalidArgumentException($directBillChoiceErrorMessage, __LINE__);
        }
        if (is_null($directBill) || (is_array($directBill) && empty($directBill))) {
            unset($this->DirectBill);
        } else {
            $this->DirectBill = $directBill;
        }
        return $this;
    }
    /**
     * Get BankAcct value
     * @return \rdyescapiacontent\StructType\BankAcctType|null
     */
    public function getBankAcct()
    {
        return isset($this->BankAcct) ? $this->BankAcct : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankAcct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAcct method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankAcctForChoiceConstraintsFromSetBankAcct($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'LoyaltyRedemption',
            'PaymentCard',
            'DirectBill',
            'Voucher',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankAcct can\'t be set as the property %s is already set. Only one property must be set among these properties: BankAcct, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankAcct value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\BankAcctType $bankAcct
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setBankAcct(\rdyescapiacontent\StructType\BankAcctType $bankAcct = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($bankAcctChoiceErrorMessage = self::validateBankAcctForChoiceConstraintsFromSetBankAcct($bankAcct))) {
            throw new \InvalidArgumentException($bankAcctChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankAcct) || (is_array($bankAcct) && empty($bankAcct))) {
            unset($this->BankAcct);
        } else {
            $this->BankAcct = $bankAcct;
        }
        return $this;
    }
    /**
     * Get Voucher value
     * @return \rdyescapiacontent\StructType\Voucher|null
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoucher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucher method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoucherForChoiceConstraintsFromSetVoucher($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'LoyaltyRedemption',
            'PaymentCard',
            'DirectBill',
            'BankAcct',
            'Cash',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Voucher can\'t be set as the property %s is already set. Only one property must be set among these properties: Voucher, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Voucher value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Voucher $voucher
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setVoucher(\rdyescapiacontent\StructType\Voucher $voucher = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($voucherChoiceErrorMessage = self::validateVoucherForChoiceConstraintsFromSetVoucher($voucher))) {
            throw new \InvalidArgumentException($voucherChoiceErrorMessage, __LINE__);
        }
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
    /**
     * Get Cash value
     * @return \rdyescapiacontent\StructType\Cash|null
     */
    public function getCash()
    {
        return isset($this->Cash) ? $this->Cash : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCash method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCash method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCashForChoiceConstraintsFromSetCash($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MiscChargeOrder',
            'LoyaltyRedemption',
            'PaymentCard',
            'DirectBill',
            'BankAcct',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Cash can\'t be set as the property %s is already set. Only one property must be set among these properties: Cash, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Cash value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Cash $cash
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setCash(\rdyescapiacontent\StructType\Cash $cash = null)
    {
        // validation for constraint: choice(MiscChargeOrder, LoyaltyRedemption, PaymentCard, DirectBill, BankAcct, Voucher, Cash)
        if ('' !== ($cashChoiceErrorMessage = self::validateCashForChoiceConstraintsFromSetCash($cash))) {
            throw new \InvalidArgumentException($cashChoiceErrorMessage, __LINE__);
        }
        if (is_null($cash) || (is_array($cash) && empty($cash))) {
            unset($this->Cash);
        } else {
            $this->Cash = $cash;
        }
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterID) && !is_string($costCenterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterID, true), gettype($costCenterID)), __LINE__);
        }
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTransactionTypeCode) && !is_string($paymentTransactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTransactionTypeCode, true), gettype($paymentTransactionTypeCode)), __LINE__);
        }
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\PaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
