<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * @subpackage Structs
 */
class OperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\OperationScheduleType[]
     */
    public $OperationSchedule;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for OperationSchedulesType
     * @uses OperationSchedulesType::setOperationSchedule()
     * @uses OperationSchedulesType::setStart()
     * @uses OperationSchedulesType::setDuration()
     * @uses OperationSchedulesType::setEnd()
     * @param \rdyescapiacontent\StructType\OperationScheduleType[] $operationSchedule
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $operationSchedule = array(), $start = null, $duration = null, $end = null)
    {
        $this
            ->setOperationSchedule($operationSchedule)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get OperationSchedule value
     * @return \rdyescapiacontent\StructType\OperationScheduleType[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationScheduleForArrayConstraintsFromSetOperationSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesTypeOperationScheduleItem instanceof \rdyescapiacontent\StructType\OperationScheduleType) {
                $invalidValues[] = is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : sprintf('%s(%s)', gettype($operationSchedulesTypeOperationScheduleItem), var_export($operationSchedulesTypeOperationScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperationSchedule property can only contain items of type \rdyescapiacontent\StructType\OperationScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OperationScheduleType[] $operationSchedule
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($operationScheduleArrayErrorMessage = self::validateOperationScheduleForArrayConstraintsFromSetOperationSchedule($operationSchedule))) {
            throw new \InvalidArgumentException($operationScheduleArrayErrorMessage, __LINE__);
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OperationScheduleType $item
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public function addToOperationSchedule(\rdyescapiacontent\StructType\OperationScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\OperationScheduleType) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of type \rdyescapiacontent\StructType\OperationScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\OperationSchedulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
