<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType StructType
 * @subpackage Structs
 */
class CompanyInfoType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType[]
     */
    public $CompanyName;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AddressInfoType[]
     */
    public $AddressInfo;
    /**
     * The TelephoneInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TelephoneInfoType[]
     */
    public $TelephoneInfo;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The BusinessLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AddressType[]
     */
    public $BusinessLocale;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * Constructor method for CompanyInfoType
     * @uses CompanyInfoType::setCompanyName()
     * @uses CompanyInfoType::setAddressInfo()
     * @uses CompanyInfoType::setTelephoneInfo()
     * @uses CompanyInfoType::setEmail()
     * @uses CompanyInfoType::setURL()
     * @uses CompanyInfoType::setBusinessLocale()
     * @uses CompanyInfoType::setPaymentForm()
     * @uses CompanyInfoType::setContactPerson()
     * @uses CompanyInfoType::setTravelArranger()
     * @uses CompanyInfoType::setLoyaltyProgram()
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $companyName
     * @param \rdyescapiacontent\StructType\AddressInfoType[] $addressInfo
     * @param \rdyescapiacontent\StructType\TelephoneInfoType[] $telephoneInfo
     * @param \rdyescapiacontent\StructType\EmailType[] $email
     * @param \rdyescapiacontent\StructType\URL_Type[] $uRL
     * @param \rdyescapiacontent\StructType\AddressType[] $businessLocale
     * @param \rdyescapiacontent\StructType\PaymentFormType[] $paymentForm
     * @param \rdyescapiacontent\StructType\ContactPersonType[] $contactPerson
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType[] $loyaltyProgram
     */
    public function __construct(array $companyName = array(), array $addressInfo = array(), array $telephoneInfo = array(), array $email = array(), array $uRL = array(), array $businessLocale = array(), array $paymentForm = array(), array $contactPerson = array(), array $travelArranger = array(), array $loyaltyProgram = array())
    {
        $this
            ->setCompanyName($companyName)
            ->setAddressInfo($addressInfo)
            ->setTelephoneInfo($telephoneInfo)
            ->setEmail($email)
            ->setURL($uRL)
            ->setBusinessLocale($businessLocale)
            ->setPaymentForm($paymentForm)
            ->setContactPerson($contactPerson)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram);
    }
    /**
     * Get CompanyName value
     * @return \rdyescapiacontent\StructType\CompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyNameForArrayConstraintsFromSetCompanyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeCompanyNameItem instanceof \rdyescapiacontent\StructType\CompanyNameType) {
                $invalidValues[] = is_object($companyInfoTypeCompanyNameItem) ? get_class($companyInfoTypeCompanyNameItem) : sprintf('%s(%s)', gettype($companyInfoTypeCompanyNameItem), var_export($companyInfoTypeCompanyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyName property can only contain items of type \rdyescapiacontent\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType[] $companyName
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setCompanyName(array $companyName = array())
    {
        // validation for constraint: array
        if ('' !== ($companyNameArrayErrorMessage = self::validateCompanyNameForArrayConstraintsFromSetCompanyName($companyName))) {
            throw new \InvalidArgumentException($companyNameArrayErrorMessage, __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CompanyNameType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToCompanyName(\rdyescapiacontent\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of type \rdyescapiacontent\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \rdyescapiacontent\StructType\AddressInfoType[]|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressInfoForArrayConstraintsFromSetAddressInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeAddressInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeAddressInfoItem instanceof \rdyescapiacontent\StructType\AddressInfoType) {
                $invalidValues[] = is_object($companyInfoTypeAddressInfoItem) ? get_class($companyInfoTypeAddressInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeAddressInfoItem), var_export($companyInfoTypeAddressInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressInfo property can only contain items of type \rdyescapiacontent\StructType\AddressInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AddressInfoType[] $addressInfo
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setAddressInfo(array $addressInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($addressInfoArrayErrorMessage = self::validateAddressInfoForArrayConstraintsFromSetAddressInfo($addressInfo))) {
            throw new \InvalidArgumentException($addressInfoArrayErrorMessage, __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Add item to AddressInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AddressInfoType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToAddressInfo(\rdyescapiacontent\StructType\AddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The AddressInfo property can only contain items of type \rdyescapiacontent\StructType\AddressInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressInfo[] = $item;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \rdyescapiacontent\StructType\TelephoneInfoType[]|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephoneInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephoneInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTelephoneInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTelephoneInfoItem instanceof \rdyescapiacontent\StructType\TelephoneInfoType) {
                $invalidValues[] = is_object($companyInfoTypeTelephoneInfoItem) ? get_class($companyInfoTypeTelephoneInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeTelephoneInfoItem), var_export($companyInfoTypeTelephoneInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TelephoneInfo property can only contain items of type \rdyescapiacontent\StructType\TelephoneInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TelephoneInfoType[] $telephoneInfo
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setTelephoneInfo(array $telephoneInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneInfoArrayErrorMessage = self::validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo($telephoneInfo))) {
            throw new \InvalidArgumentException($telephoneInfoArrayErrorMessage, __LINE__);
        }
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Add item to TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TelephoneInfoType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToTelephoneInfo(\rdyescapiacontent\StructType\TelephoneInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TelephoneInfoType) {
            throw new \InvalidArgumentException(sprintf('The TelephoneInfo property can only contain items of type \rdyescapiacontent\StructType\TelephoneInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TelephoneInfo[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapiacontent\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeEmailItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeEmailItem instanceof \rdyescapiacontent\StructType\EmailType) {
                $invalidValues[] = is_object($companyInfoTypeEmailItem) ? get_class($companyInfoTypeEmailItem) : sprintf('%s(%s)', gettype($companyInfoTypeEmailItem), var_export($companyInfoTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \rdyescapiacontent\StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmailType[] $email
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmailType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToEmail(\rdyescapiacontent\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \rdyescapiacontent\StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapiacontent\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeURLItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeURLItem instanceof \rdyescapiacontent\StructType\URL_Type) {
                $invalidValues[] = is_object($companyInfoTypeURLItem) ? get_class($companyInfoTypeURLItem) : sprintf('%s(%s)', gettype($companyInfoTypeURLItem), var_export($companyInfoTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \rdyescapiacontent\StructType\URL_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\URL_Type[] $uRL
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\URL_Type $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToURL(\rdyescapiacontent\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \rdyescapiacontent\StructType\URL_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get BusinessLocale value
     * @return \rdyescapiacontent\StructType\AddressType[]|null
     */
    public function getBusinessLocale()
    {
        return $this->BusinessLocale;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessLocale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessLocale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeBusinessLocaleItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeBusinessLocaleItem instanceof \rdyescapiacontent\StructType\AddressType) {
                $invalidValues[] = is_object($companyInfoTypeBusinessLocaleItem) ? get_class($companyInfoTypeBusinessLocaleItem) : sprintf('%s(%s)', gettype($companyInfoTypeBusinessLocaleItem), var_export($companyInfoTypeBusinessLocaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessLocale property can only contain items of type \rdyescapiacontent\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AddressType[] $businessLocale
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setBusinessLocale(array $businessLocale = array())
    {
        // validation for constraint: array
        if ('' !== ($businessLocaleArrayErrorMessage = self::validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale($businessLocale))) {
            throw new \InvalidArgumentException($businessLocaleArrayErrorMessage, __LINE__);
        }
        $this->BusinessLocale = $businessLocale;
        return $this;
    }
    /**
     * Add item to BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AddressType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToBusinessLocale(\rdyescapiacontent\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The BusinessLocale property can only contain items of type \rdyescapiacontent\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessLocale[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \rdyescapiacontent\StructType\PaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypePaymentFormItem instanceof \rdyescapiacontent\StructType\PaymentFormType) {
                $invalidValues[] = is_object($companyInfoTypePaymentFormItem) ? get_class($companyInfoTypePaymentFormItem) : sprintf('%s(%s)', gettype($companyInfoTypePaymentFormItem), var_export($companyInfoTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \rdyescapiacontent\StructType\PaymentFormType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormType[] $paymentForm
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToPaymentForm(\rdyescapiacontent\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \rdyescapiacontent\StructType\PaymentFormType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \rdyescapiacontent\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeContactPersonItem instanceof \rdyescapiacontent\StructType\ContactPersonType) {
                $invalidValues[] = is_object($companyInfoTypeContactPersonItem) ? get_class($companyInfoTypeContactPersonItem) : sprintf('%s(%s)', gettype($companyInfoTypeContactPersonItem), var_export($companyInfoTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type \rdyescapiacontent\StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ContactPersonType[] $contactPerson
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ContactPersonType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToContactPerson(\rdyescapiacontent\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type \rdyescapiacontent\StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapiacontent\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTravelArrangerItem instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
                $invalidValues[] = is_object($companyInfoTypeTravelArrangerItem) ? get_class($companyInfoTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($companyInfoTypeTravelArrangerItem), var_export($companyInfoTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \rdyescapiacontent\StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToTravelArranger(\rdyescapiacontent\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \rdyescapiacontent\StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \rdyescapiacontent\StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeLoyaltyProgramItem instanceof \rdyescapiacontent\StructType\LoyaltyProgramType) {
                $invalidValues[] = is_object($companyInfoTypeLoyaltyProgramItem) ? get_class($companyInfoTypeLoyaltyProgramItem) : sprintf('%s(%s)', gettype($companyInfoTypeLoyaltyProgramItem), var_export($companyInfoTypeLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type \rdyescapiacontent\StructType\LoyaltyProgramType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\LoyaltyProgramType $item
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public function addToLoyaltyProgram(\rdyescapiacontent\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type \rdyescapiacontent\StructType\LoyaltyProgramType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\CompanyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
