<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountPercentType StructType
 * @subpackage Structs
 */
class AmountPercentType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TaxesType
     */
    public $Taxes;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The FeesInclusive
     * @var bool
     */
    public $FeesInclusive;
    /**
     * The NmbrOfNights
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The BasisType
     * @var string
     */
    public $BasisType;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for AmountPercentType
     * @uses AmountPercentType::setTaxes()
     * @uses AmountPercentType::setTaxInclusive()
     * @uses AmountPercentType::setFeesInclusive()
     * @uses AmountPercentType::setNmbrOfNights()
     * @uses AmountPercentType::setBasisType()
     * @uses AmountPercentType::setPercent()
     * @uses AmountPercentType::setAmount()
     * @param \rdyescapiacontent\StructType\TaxesType $taxes
     * @param bool $taxInclusive
     * @param bool $feesInclusive
     * @param int $nmbrOfNights
     * @param string $basisType
     * @param float $percent
     * @param float $amount
     */
    public function __construct(\rdyescapiacontent\StructType\TaxesType $taxes = null, $taxInclusive = null, $feesInclusive = null, $nmbrOfNights = null, $basisType = null, $percent = null, $amount = null)
    {
        $this
            ->setTaxes($taxes)
            ->setTaxInclusive($taxInclusive)
            ->setFeesInclusive($feesInclusive)
            ->setNmbrOfNights($nmbrOfNights)
            ->setBasisType($basisType)
            ->setPercent($percent)
            ->setAmount($amount);
    }
    /**
     * Get Taxes value
     * @return \rdyescapiacontent\StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \rdyescapiacontent\StructType\TaxesType $taxes
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setTaxes(\rdyescapiacontent\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get FeesInclusive value
     * @return bool|null
     */
    public function getFeesInclusive()
    {
        return $this->FeesInclusive;
    }
    /**
     * Set FeesInclusive value
     * @param bool $feesInclusive
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setFeesInclusive($feesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($feesInclusive) && !is_bool($feesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($feesInclusive, true), gettype($feesInclusive)), __LINE__);
        }
        $this->FeesInclusive = $feesInclusive;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !(is_int($nmbrOfNights) || ctype_digit($nmbrOfNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmbrOfNights, true), gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get BasisType value
     * @return string|null
     */
    public function getBasisType()
    {
        return $this->BasisType;
    }
    /**
     * Set BasisType value
     * @param string $basisType
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setBasisType($basisType = null)
    {
        // validation for constraint: string
        if (!is_null($basisType) && !is_string($basisType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basisType, true), gettype($basisType)), __LINE__);
        }
        $this->BasisType = $basisType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\AmountPercentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
