<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitRef StructType
 * @subpackage Structs
 */
class UnitRef extends AbstractStructBase
{
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The UnitClassCode
     * @var string
     */
    public $UnitClassCode;
    /**
     * Constructor method for UnitRef
     * @uses UnitRef::setPropertyManagerCode()
     * @uses UnitRef::setUnitCode()
     * @uses UnitRef::setUnitName()
     * @uses UnitRef::setInfoSource()
     * @uses UnitRef::setInternalUnitCode()
     * @uses UnitRef::setUnitHeadline()
     * @uses UnitRef::setUnitClassCode()
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $unitClassCode
     */
    public function __construct($propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $unitClassCode = null)
    {
        $this
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setUnitClassCode($unitClassCode);
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalUnitCode, true), gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitHeadline, true), gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get UnitClassCode value
     * @return string|null
     */
    public function getUnitClassCode()
    {
        return $this->UnitClassCode;
    }
    /**
     * Set UnitClassCode value
     * @param string $unitClassCode
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public function setUnitClassCode($unitClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitClassCode) && !is_string($unitClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitClassCode, true), gettype($unitClassCode)), __LINE__);
        }
        $this->UnitClassCode = $unitClassCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
