<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliationsType StructType
 * @subpackage Structs
 */
class AffiliationsType extends AbstractStructBase
{
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\OrganizationType[]
     */
    public $Organization;
    /**
     * The Employer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmployerType[]
     */
    public $Employer;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The TravelClub
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TravelClubType[]
     */
    public $TravelClub;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\InsuranceType[]
     */
    public $Insurance;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AffiliationsType
     * @uses AffiliationsType::setOrganization()
     * @uses AffiliationsType::setEmployer()
     * @uses AffiliationsType::setTravelArranger()
     * @uses AffiliationsType::setTravelClub()
     * @uses AffiliationsType::setInsurance()
     * @uses AffiliationsType::setTPA_Extensions()
     * @uses AffiliationsType::setShareSynchInd()
     * @uses AffiliationsType::setShareMarketInd()
     * @param \rdyescapiacontent\StructType\OrganizationType[] $organization
     * @param \rdyescapiacontent\StructType\EmployerType[] $employer
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapiacontent\StructType\TravelClubType[] $travelClub
     * @param \rdyescapiacontent\StructType\InsuranceType[] $insurance
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $organization = array(), array $employer = array(), array $travelArranger = array(), array $travelClub = array(), array $insurance = array(), \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setOrganization($organization)
            ->setEmployer($employer)
            ->setTravelArranger($travelArranger)
            ->setTravelClub($travelClub)
            ->setInsurance($insurance)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Organization value
     * @return \rdyescapiacontent\StructType\OrganizationType[]|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganizationForArrayConstraintsFromSetOrganization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeOrganizationItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeOrganizationItem instanceof \rdyescapiacontent\StructType\OrganizationType) {
                $invalidValues[] = is_object($affiliationsTypeOrganizationItem) ? get_class($affiliationsTypeOrganizationItem) : sprintf('%s(%s)', gettype($affiliationsTypeOrganizationItem), var_export($affiliationsTypeOrganizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization property can only contain items of type \rdyescapiacontent\StructType\OrganizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OrganizationType[] $organization
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setOrganization(array $organization = array())
    {
        // validation for constraint: array
        if ('' !== ($organizationArrayErrorMessage = self::validateOrganizationForArrayConstraintsFromSetOrganization($organization))) {
            throw new \InvalidArgumentException($organizationArrayErrorMessage, __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Add item to Organization value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\OrganizationType $item
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function addToOrganization(\rdyescapiacontent\StructType\OrganizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\OrganizationType) {
            throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of type \rdyescapiacontent\StructType\OrganizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization[] = $item;
        return $this;
    }
    /**
     * Get Employer value
     * @return \rdyescapiacontent\StructType\EmployerType[]|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployerForArrayConstraintsFromSetEmployer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeEmployerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeEmployerItem instanceof \rdyescapiacontent\StructType\EmployerType) {
                $invalidValues[] = is_object($affiliationsTypeEmployerItem) ? get_class($affiliationsTypeEmployerItem) : sprintf('%s(%s)', gettype($affiliationsTypeEmployerItem), var_export($affiliationsTypeEmployerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employer property can only contain items of type \rdyescapiacontent\StructType\EmployerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employer value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployerType[] $employer
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setEmployer(array $employer = array())
    {
        // validation for constraint: array
        if ('' !== ($employerArrayErrorMessage = self::validateEmployerForArrayConstraintsFromSetEmployer($employer))) {
            throw new \InvalidArgumentException($employerArrayErrorMessage, __LINE__);
        }
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Add item to Employer value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployerType $item
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function addToEmployer(\rdyescapiacontent\StructType\EmployerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EmployerType) {
            throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of type \rdyescapiacontent\StructType\EmployerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employer[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapiacontent\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelArrangerItem instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
                $invalidValues[] = is_object($affiliationsTypeTravelArrangerItem) ? get_class($affiliationsTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($affiliationsTypeTravelArrangerItem), var_export($affiliationsTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \rdyescapiacontent\StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelArrangerType $item
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function addToTravelArranger(\rdyescapiacontent\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \rdyescapiacontent\StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get TravelClub value
     * @return \rdyescapiacontent\StructType\TravelClubType[]|null
     */
    public function getTravelClub()
    {
        return $this->TravelClub;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelClub method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelClub method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelClubForArrayConstraintsFromSetTravelClub(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeTravelClubItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelClubItem instanceof \rdyescapiacontent\StructType\TravelClubType) {
                $invalidValues[] = is_object($affiliationsTypeTravelClubItem) ? get_class($affiliationsTypeTravelClubItem) : sprintf('%s(%s)', gettype($affiliationsTypeTravelClubItem), var_export($affiliationsTypeTravelClubItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelClub property can only contain items of type \rdyescapiacontent\StructType\TravelClubType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelClub value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelClubType[] $travelClub
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setTravelClub(array $travelClub = array())
    {
        // validation for constraint: array
        if ('' !== ($travelClubArrayErrorMessage = self::validateTravelClubForArrayConstraintsFromSetTravelClub($travelClub))) {
            throw new \InvalidArgumentException($travelClubArrayErrorMessage, __LINE__);
        }
        $this->TravelClub = $travelClub;
        return $this;
    }
    /**
     * Add item to TravelClub value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\TravelClubType $item
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function addToTravelClub(\rdyescapiacontent\StructType\TravelClubType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\TravelClubType) {
            throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of type \rdyescapiacontent\StructType\TravelClubType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelClub[] = $item;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \rdyescapiacontent\StructType\InsuranceType[]|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuranceForArrayConstraintsFromSetInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeInsuranceItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeInsuranceItem instanceof \rdyescapiacontent\StructType\InsuranceType) {
                $invalidValues[] = is_object($affiliationsTypeInsuranceItem) ? get_class($affiliationsTypeInsuranceItem) : sprintf('%s(%s)', gettype($affiliationsTypeInsuranceItem), var_export($affiliationsTypeInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Insurance property can only contain items of type \rdyescapiacontent\StructType\InsuranceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Insurance value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\InsuranceType[] $insurance
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setInsurance(array $insurance = array())
    {
        // validation for constraint: array
        if ('' !== ($insuranceArrayErrorMessage = self::validateInsuranceForArrayConstraintsFromSetInsurance($insurance))) {
            throw new \InvalidArgumentException($insuranceArrayErrorMessage, __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Add item to Insurance value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\InsuranceType $item
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function addToInsurance(\rdyescapiacontent\StructType\InsuranceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\InsuranceType) {
            throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of type \rdyescapiacontent\StructType\InsuranceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Insurance[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\AffiliationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
