<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResRequestType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class UnitResRequestType extends EVRN_BaseRQType
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The UnitReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * Constructor method for UnitResRequestType
     * @uses UnitResRequestType::setUniqueID()
     * @uses UnitResRequestType::setUnitReservations()
     * @uses UnitResRequestType::setResStatus()
     * @param \rdyescapiacontent\StructType\UniqueID_Type[] $uniqueID
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @param string $resStatus
     */
    public function __construct(array $uniqueID = array(), \rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null, $resStatus = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setUnitReservations($unitReservations)
            ->setResStatus($resStatus);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapiacontent\StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitResRequestTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$unitResRequestTypeUniqueIDItem instanceof \rdyescapiacontent\StructType\UniqueID_Type) {
                $invalidValues[] = is_object($unitResRequestTypeUniqueIDItem) ? get_class($unitResRequestTypeUniqueIDItem) : sprintf('%s(%s)', gettype($unitResRequestTypeUniqueIDItem), var_export($unitResRequestTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \rdyescapiacontent\StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UniqueID_Type[] $uniqueID
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UniqueID_Type $item
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function addToUniqueID(\rdyescapiacontent\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \rdyescapiacontent\StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapiacontent\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setUnitReservations(\rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \rdyescapiacontent\EnumType\TransactionActionType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapiacontent\EnumType\TransactionActionType', is_array($resStatus) ? implode(', ', $resStatus) : var_export($resStatus, true), implode(', ', \rdyescapiacontent\EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
