<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptions StructType
 * @subpackage Structs
 */
class MultimediaDescriptions extends MultimediaDescriptionsType
{
    /**
     * The InfoCode
     * @var string
     */
    public $InfoCode;
    /**
     * The AdditionalDetailCode
     * @var string
     */
    public $AdditionalDetailCode;
    /**
     * Constructor method for MultimediaDescriptions
     * @uses MultimediaDescriptions::setInfoCode()
     * @uses MultimediaDescriptions::setAdditionalDetailCode()
     * @param string $infoCode
     * @param string $additionalDetailCode
     */
    public function __construct($infoCode = null, $additionalDetailCode = null)
    {
        $this
            ->setInfoCode($infoCode)
            ->setAdditionalDetailCode($additionalDetailCode);
    }
    /**
     * Get InfoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @param string $infoCode
     * @return \rdyescapiacontent\StructType\MultimediaDescriptions
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoCode, true), gettype($infoCode)), __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Get AdditionalDetailCode value
     * @return string|null
     */
    public function getAdditionalDetailCode()
    {
        return $this->AdditionalDetailCode;
    }
    /**
     * Set AdditionalDetailCode value
     * @param string $additionalDetailCode
     * @return \rdyescapiacontent\StructType\MultimediaDescriptions
     */
    public function setAdditionalDetailCode($additionalDetailCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetailCode) && !is_string($additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetailCode, true), gettype($additionalDetailCode)), __LINE__);
        }
        $this->AdditionalDetailCode = $additionalDetailCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\MultimediaDescriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
