<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehiclePrefType StructType
 * Meta informations extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class VehiclePrefType extends VehicleCoreType
{
    /**
     * The TypePref
     * @var string
     */
    public $TypePref;
    /**
     * The ClassPref
     * @var string
     */
    public $ClassPref;
    /**
     * The AirConditionPref
     * @var string
     */
    public $AirConditionPref;
    /**
     * The TransmissionPref
     * @var string
     */
    public $TransmissionPref;
    /**
     * The VendorCarType
     * @var string
     */
    public $VendorCarType;
    /**
     * The VehicleQty
     * @var int
     */
    public $VehicleQty;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for VehiclePrefType
     * @uses VehiclePrefType::setTypePref()
     * @uses VehiclePrefType::setClassPref()
     * @uses VehiclePrefType::setAirConditionPref()
     * @uses VehiclePrefType::setTransmissionPref()
     * @uses VehiclePrefType::setVendorCarType()
     * @uses VehiclePrefType::setVehicleQty()
     * @uses VehiclePrefType::setCode()
     * @uses VehiclePrefType::setCodeContext()
     * @param string $typePref
     * @param string $classPref
     * @param string $airConditionPref
     * @param string $transmissionPref
     * @param string $vendorCarType
     * @param int $vehicleQty
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($typePref = null, $classPref = null, $airConditionPref = null, $transmissionPref = null, $vendorCarType = null, $vehicleQty = null, $code = null, $codeContext = null)
    {
        $this
            ->setTypePref($typePref)
            ->setClassPref($classPref)
            ->setAirConditionPref($airConditionPref)
            ->setTransmissionPref($transmissionPref)
            ->setVendorCarType($vendorCarType)
            ->setVehicleQty($vehicleQty)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get TypePref value
     * @return string|null
     */
    public function getTypePref()
    {
        return $this->TypePref;
    }
    /**
     * Set TypePref value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typePref
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setTypePref($typePref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($typePref)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typePref, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TypePref = $typePref;
        return $this;
    }
    /**
     * Get ClassPref value
     * @return string|null
     */
    public function getClassPref()
    {
        return $this->ClassPref;
    }
    /**
     * Set ClassPref value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classPref
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setClassPref($classPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($classPref)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $classPref, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->ClassPref = $classPref;
        return $this;
    }
    /**
     * Get AirConditionPref value
     * @return string|null
     */
    public function getAirConditionPref()
    {
        return $this->AirConditionPref;
    }
    /**
     * Set AirConditionPref value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airConditionPref
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setAirConditionPref($airConditionPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($airConditionPref)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airConditionPref, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->AirConditionPref = $airConditionPref;
        return $this;
    }
    /**
     * Get TransmissionPref value
     * @return string|null
     */
    public function getTransmissionPref()
    {
        return $this->TransmissionPref;
    }
    /**
     * Set TransmissionPref value
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionPref
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setTransmissionPref($transmissionPref = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PreferLevelType::valueIsValid($transmissionPref)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transmissionPref, implode(', ', \rdyescapiacontent\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TransmissionPref = $transmissionPref;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCarType)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get VehicleQty value
     * @return int|null
     */
    public function getVehicleQty()
    {
        return $this->VehicleQty;
    }
    /**
     * Set VehicleQty value
     * @param int $vehicleQty
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setVehicleQty($vehicleQty = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleQty) && !is_numeric($vehicleQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vehicleQty)), __LINE__);
        }
        $this->VehicleQty = $vehicleQty;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\VehiclePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
