<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStay StructType
 * @subpackage Structs
 */
class UnitStay extends UnitStayType
{
    /**
     * The ResGuestRPHs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH
     */
    public $ResGuestRPHs;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The ServiceRPHs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Reference
     */
    public $Reference;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * The UnitRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The StayDateRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DepositPayments
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CancelPenalties
     */
    public $CancelPenalties;
    /**
     * The BasicUnitInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\BasicUnitInfo
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\RentalAgreement
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The AdditionalCharges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AdditionalCharges
     */
    public $AdditionalCharges;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * Constructor method for UnitStay
     * @uses UnitStay::setResGuestRPHs()
     * @uses UnitStay::setComments()
     * @uses UnitStay::setSpecialRequests()
     * @uses UnitStay::setServiceRPHs()
     * @uses UnitStay::setReference()
     * @uses UnitStay::setIndexNumber()
     * @uses UnitStay::setUnitRef()
     * @uses UnitStay::setStayDateRange()
     * @uses UnitStay::setGuestCounts()
     * @uses UnitStay::setDepositPayments()
     * @uses UnitStay::setCancelPenalties()
     * @uses UnitStay::setBasicUnitInfo()
     * @uses UnitStay::setRentalAgreement()
     * @uses UnitStay::setPets()
     * @uses UnitStay::setAdditionalCharges()
     * @uses UnitStay::setAvailableOnlyIndicator()
     * @param \rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @param \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment $comments
     * @param \rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param \rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param \rdyescapiacontent\StructType\Reference $reference
     * @param int $indexNumber
     * @param \rdyescapiacontent\StructType\UnitRef $unitRef
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @param \rdyescapiacontent\StructType\DepositPayments $depositPayments
     * @param \rdyescapiacontent\StructType\CancelPenalties $cancelPenalties
     * @param \rdyescapiacontent\StructType\BasicUnitInfo $basicUnitInfo
     * @param \rdyescapiacontent\StructType\RentalAgreement $rentalAgreement
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $pets
     * @param \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges
     * @param bool $availableOnlyIndicator
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null, \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment $comments = null, \rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, \rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, \rdyescapiacontent\StructType\Reference $reference = null, $indexNumber = null, \rdyescapiacontent\StructType\UnitRef $unitRef = null, \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange = null, \rdyescapiacontent\StructType\GuestCountType $guestCounts = null, \rdyescapiacontent\StructType\DepositPayments $depositPayments = null, \rdyescapiacontent\StructType\CancelPenalties $cancelPenalties = null, \rdyescapiacontent\StructType\BasicUnitInfo $basicUnitInfo = null, \rdyescapiacontent\StructType\RentalAgreement $rentalAgreement = null, \rdyescapiacontent\StructType\PetsPoliciesType $pets = null, \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges = null, $availableOnlyIndicator = null)
    {
        $this
            ->setResGuestRPHs($resGuestRPHs)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setServiceRPHs($serviceRPHs)
            ->setReference($reference)
            ->setIndexNumber($indexNumber)
            ->setUnitRef($unitRef)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setAdditionalCharges($additionalCharges)
            ->setAvailableOnlyIndicator($availableOnlyIndicator);
    }
    /**
     * Get ResGuestRPHs value
     * @return \rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setResGuestRPHs(\rdyescapiacontent\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Comments value
     * @return \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment $comments
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setComments(\rdyescapiacontent\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setSpecialRequests(\rdyescapiacontent\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setServiceRPHs(\rdyescapiacontent\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get Reference value
     * @return \rdyescapiacontent\StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \rdyescapiacontent\StructType\Reference $reference
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setReference(\rdyescapiacontent\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !is_numeric($indexNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get UnitRef value
     * @return \rdyescapiacontent\StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \rdyescapiacontent\StructType\UnitRef $unitRef
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setUnitRef(\rdyescapiacontent\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \rdyescapiacontent\StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setStayDateRange(\rdyescapiacontent\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapiacontent\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapiacontent\StructType\GuestCountType $guestCounts
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setGuestCounts(\rdyescapiacontent\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \rdyescapiacontent\StructType\DepositPayments|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \rdyescapiacontent\StructType\DepositPayments $depositPayments
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setDepositPayments(\rdyescapiacontent\StructType\DepositPayments $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \rdyescapiacontent\StructType\CancelPenalties|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \rdyescapiacontent\StructType\CancelPenalties $cancelPenalties
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setCancelPenalties(\rdyescapiacontent\StructType\CancelPenalties $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \rdyescapiacontent\StructType\BasicUnitInfo|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \rdyescapiacontent\StructType\BasicUnitInfo $basicUnitInfo
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setBasicUnitInfo(\rdyescapiacontent\StructType\BasicUnitInfo $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \rdyescapiacontent\StructType\RentalAgreement|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \rdyescapiacontent\StructType\RentalAgreement $rentalAgreement
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setRentalAgreement(\rdyescapiacontent\StructType\RentalAgreement $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \rdyescapiacontent\StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \rdyescapiacontent\StructType\PetsPoliciesType $pets
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setPets(\rdyescapiacontent\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \rdyescapiacontent\StructType\AdditionalCharges|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \rdyescapiacontent\StructType\AdditionalCharges $additionalCharges
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setAdditionalCharges(\rdyescapiacontent\StructType\AdditionalCharges $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
