<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResResponseType StructType
 * Meta informations extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class UnitResResponseType extends EVRN_BaseRSType
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\SuccessType
     */
    public $Success;
    /**
     * The UnitReservations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for UnitResResponseType
     * @uses UnitResResponseType::setPOS()
     * @uses UnitResResponseType::setWarnings()
     * @uses UnitResResponseType::setErrors()
     * @uses UnitResResponseType::setSuccess()
     * @uses UnitResResponseType::setUnitReservations()
     * @uses UnitResResponseType::setResResponseType()
     * @param \rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS
     * @param \rdyescapiacontent\StructType\WarningsType $warnings
     * @param \rdyescapiacontent\StructType\ErrorsType $errors
     * @param \rdyescapiacontent\StructType\SuccessType $success
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @param string $resResponseType
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS = null, \rdyescapiacontent\StructType\WarningsType $warnings = null, \rdyescapiacontent\StructType\ErrorsType $errors = null, \rdyescapiacontent\StructType\SuccessType $success = null, \rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setUnitReservations($unitReservations)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return \rdyescapiacontent\ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setPOS(\rdyescapiacontent\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \rdyescapiacontent\StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \rdyescapiacontent\StructType\WarningsType $warnings
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setWarnings(\rdyescapiacontent\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Errors value
     * @return \rdyescapiacontent\StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \rdyescapiacontent\StructType\ErrorsType $errors
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setErrors(\rdyescapiacontent\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \rdyescapiacontent\StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \rdyescapiacontent\StructType\SuccessType $success
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setSuccess(\rdyescapiacontent\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapiacontent\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setUnitReservations(\rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \rdyescapiacontent\EnumType\TransactionStatusType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resResponseType, implode(', ', \rdyescapiacontent\EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitResResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
