<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResRequestType StructType
 * Meta informations extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class UnitResRequestType extends EVRN_BaseRQType
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The UnitReservations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * Constructor method for UnitResRequestType
     * @uses UnitResRequestType::setUniqueID()
     * @uses UnitResRequestType::setUnitReservations()
     * @uses UnitResRequestType::setResStatus()
     * @param \rdyescapiacontent\StructType\UniqueID_Type[] $uniqueID
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @param string $resStatus
     */
    public function __construct(array $uniqueID = array(), \rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null, $resStatus = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setUnitReservations($unitReservations)
            ->setResStatus($resStatus);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapiacontent\StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UniqueID_Type[] $uniqueID
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        foreach ($uniqueID as $unitResRequestTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$unitResRequestTypeUniqueIDItem instanceof \rdyescapiacontent\StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \rdyescapiacontent\StructType\UniqueID_Type, "%s" given', is_object($unitResRequestTypeUniqueIDItem) ? get_class($unitResRequestTypeUniqueIDItem) : gettype($unitResRequestTypeUniqueIDItem)), __LINE__);
            }
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UniqueID_Type $item
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function addToUniqueID(\rdyescapiacontent\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \rdyescapiacontent\StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapiacontent\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \rdyescapiacontent\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setUnitReservations(\rdyescapiacontent\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \rdyescapiacontent\EnumType\TransactionActionType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\TransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\TransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resStatus, implode(', ', \rdyescapiacontent\EnumType\TransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitResRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
