<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveInfoRequestType StructType
 * @subpackage Structs
 */
class UnitDescriptiveInfoRequestType extends AbstractStructBase
{
    /**
     * The UnitInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitInfo
     */
    public $UnitInfo;
    /**
     * The Policies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Policies
     */
    public $Policies;
    /**
     * The UnitReviews
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitReviews
     */
    public $UnitReviews;
    /**
     * The Promotions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Promotions
     */
    public $Promotions;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The StateCodeList
     * @var string[]
     */
    public $StateCodeList;
    /**
     * The CountryCodeList
     * @var string[]
     */
    public $CountryCodeList;
    /**
     * The BrandCodeList
     * @var string[]
     */
    public $BrandCodeList;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The UpdatedAfter
     * @var string
     */
    public $UpdatedAfter;
    /**
     * Constructor method for UnitDescriptiveInfoRequestType
     * @uses UnitDescriptiveInfoRequestType::setUnitInfo()
     * @uses UnitDescriptiveInfoRequestType::setPolicies()
     * @uses UnitDescriptiveInfoRequestType::setUnitReviews()
     * @uses UnitDescriptiveInfoRequestType::setPromotions()
     * @uses UnitDescriptiveInfoRequestType::setPropertyManagerCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitName()
     * @uses UnitDescriptiveInfoRequestType::setInfoSource()
     * @uses UnitDescriptiveInfoRequestType::setInternalUnitCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitHeadline()
     * @uses UnitDescriptiveInfoRequestType::setStateCodeList()
     * @uses UnitDescriptiveInfoRequestType::setCountryCodeList()
     * @uses UnitDescriptiveInfoRequestType::setBrandCodeList()
     * @uses UnitDescriptiveInfoRequestType::setMoreDataEchoToken()
     * @uses UnitDescriptiveInfoRequestType::setUpdatedAfter()
     * @param \rdyescapiacontent\StructType\UnitInfo $unitInfo
     * @param \rdyescapiacontent\StructType\Policies $policies
     * @param \rdyescapiacontent\StructType\UnitReviews $unitReviews
     * @param \rdyescapiacontent\StructType\Promotions $promotions
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string[] $stateCodeList
     * @param string[] $countryCodeList
     * @param string[] $brandCodeList
     * @param string $moreDataEchoToken
     * @param string $updatedAfter
     */
    public function __construct(\rdyescapiacontent\StructType\UnitInfo $unitInfo = null, \rdyescapiacontent\StructType\Policies $policies = null, \rdyescapiacontent\StructType\UnitReviews $unitReviews = null, \rdyescapiacontent\StructType\Promotions $promotions = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, array $stateCodeList = array(), array $countryCodeList = array(), array $brandCodeList = array(), $moreDataEchoToken = null, $updatedAfter = null)
    {
        $this
            ->setUnitInfo($unitInfo)
            ->setPolicies($policies)
            ->setUnitReviews($unitReviews)
            ->setPromotions($promotions)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setStateCodeList($stateCodeList)
            ->setCountryCodeList($countryCodeList)
            ->setBrandCodeList($brandCodeList)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setUpdatedAfter($updatedAfter);
    }
    /**
     * Get UnitInfo value
     * @return \rdyescapiacontent\StructType\UnitInfo|null
     */
    public function getUnitInfo()
    {
        return $this->UnitInfo;
    }
    /**
     * Set UnitInfo value
     * @param \rdyescapiacontent\StructType\UnitInfo $unitInfo
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitInfo(\rdyescapiacontent\StructType\UnitInfo $unitInfo = null)
    {
        $this->UnitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get Policies value
     * @return \rdyescapiacontent\StructType\Policies|null
     */
    public function getPolicies()
    {
        return $this->Policies;
    }
    /**
     * Set Policies value
     * @param \rdyescapiacontent\StructType\Policies $policies
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPolicies(\rdyescapiacontent\StructType\Policies $policies = null)
    {
        $this->Policies = $policies;
        return $this;
    }
    /**
     * Get UnitReviews value
     * @return \rdyescapiacontent\StructType\UnitReviews|null
     */
    public function getUnitReviews()
    {
        return $this->UnitReviews;
    }
    /**
     * Set UnitReviews value
     * @param \rdyescapiacontent\StructType\UnitReviews $unitReviews
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitReviews(\rdyescapiacontent\StructType\UnitReviews $unitReviews = null)
    {
        $this->UnitReviews = $unitReviews;
        return $this;
    }
    /**
     * Get Promotions value
     * @return \rdyescapiacontent\StructType\Promotions|null
     */
    public function getPromotions()
    {
        return $this->Promotions;
    }
    /**
     * Set Promotions value
     * @param \rdyescapiacontent\StructType\Promotions $promotions
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPromotions(\rdyescapiacontent\StructType\Promotions $promotions = null)
    {
        $this->Promotions = $promotions;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get StateCodeList value
     * @return string[]|null
     */
    public function getStateCodeList()
    {
        return $this->StateCodeList;
    }
    /**
     * Set StateCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $stateCodeList
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setStateCodeList(array $stateCodeList = array())
    {
        foreach ($stateCodeList as $unitDescriptiveInfoRequestTypeStateCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeStateCodeListItem)) {
                throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of string, "%s" given', is_object($unitDescriptiveInfoRequestTypeStateCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeStateCodeListItem) : gettype($unitDescriptiveInfoRequestTypeStateCodeListItem)), __LINE__);
            }
        }
        $this->StateCodeList = $stateCodeList;
        return $this;
    }
    /**
     * Add item to StateCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToStateCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateCodeList[] = $item;
        return $this;
    }
    /**
     * Get CountryCodeList value
     * @return string[]|null
     */
    public function getCountryCodeList()
    {
        return $this->CountryCodeList;
    }
    /**
     * Set CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $countryCodeList
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setCountryCodeList(array $countryCodeList = array())
    {
        foreach ($countryCodeList as $unitDescriptiveInfoRequestTypeCountryCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeCountryCodeListItem)) {
                throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of string, "%s" given', is_object($unitDescriptiveInfoRequestTypeCountryCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeCountryCodeListItem) : gettype($unitDescriptiveInfoRequestTypeCountryCodeListItem)), __LINE__);
            }
        }
        $this->CountryCodeList = $countryCodeList;
        return $this;
    }
    /**
     * Add item to CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToCountryCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CountryCodeList[] = $item;
        return $this;
    }
    /**
     * Get BrandCodeList value
     * @return string[]|null
     */
    public function getBrandCodeList()
    {
        return $this->BrandCodeList;
    }
    /**
     * Set BrandCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $brandCodeList
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setBrandCodeList(array $brandCodeList = array())
    {
        foreach ($brandCodeList as $unitDescriptiveInfoRequestTypeBrandCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeBrandCodeListItem)) {
                throw new \InvalidArgumentException(sprintf('The BrandCodeList property can only contain items of string, "%s" given', is_object($unitDescriptiveInfoRequestTypeBrandCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeBrandCodeListItem) : gettype($unitDescriptiveInfoRequestTypeBrandCodeListItem)), __LINE__);
            }
        }
        $this->BrandCodeList = $brandCodeList;
        return $this;
    }
    /**
     * Add item to BrandCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToBrandCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BrandCodeList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BrandCodeList[] = $item;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get UpdatedAfter value
     * @return string|null
     */
    public function getUpdatedAfter()
    {
        return $this->UpdatedAfter;
    }
    /**
     * Set UpdatedAfter value
     * @param string $updatedAfter
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUpdatedAfter($updatedAfter = null)
    {
        // validation for constraint: string
        if (!is_null($updatedAfter) && !is_string($updatedAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updatedAfter)), __LINE__);
        }
        $this->UpdatedAfter = $updatedAfter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\UnitDescriptiveInfoRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
