<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AmountType[]
     */
    public $Price;
    /**
     * The ServiceDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ResCommonDetailType
     */
    public $ServiceDetails;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ServicePricingType
     * @var string
     */
    public $ServicePricingType;
    /**
     * The ReservationStatusType
     * @var string
     */
    public $ReservationStatusType;
    /**
     * The ServiceRPH
     * @var string
     */
    public $ServiceRPH;
    /**
     * The ServiceInventoryCode
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The InventoryBlockCode
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The PriceGuaranteed
     * @var bool
     */
    public $PriceGuaranteed;
    /**
     * The Inclusive
     * @var bool
     */
    public $Inclusive;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The RelativePosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\RelativePositionType
     */
    public $RelativePosition;
    /**
     * The OperationSchedules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule
     */
    public $OperationSchedules;
    /**
     * The MultimediaDescriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature
     */
    public $Features;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The Included
     * @var bool
     */
    public $Included;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The BusinessServiceCode
     * @var string
     */
    public $BusinessServiceCode;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The AvailableToAnyGuest
     * @var bool
     */
    public $AvailableToAnyGuest;
    /**
     * The InvCode
     * @var string
     */
    public $InvCode;
    /**
     * The ProximityCode
     * @var string
     */
    public $ProximityCode;
    /**
     * The MealPlanCode
     * @var string
     */
    public $MealPlanCode;
    /**
     * The Sort
     * @var int
     */
    public $Sort;
    /**
     * The MeetingRoomCode
     * @var string
     */
    public $MeetingRoomCode;
    /**
     * Constructor method for Service
     * @uses Service::setPrice()
     * @uses Service::setServiceDetails()
     * @uses Service::setTPA_Extensions()
     * @uses Service::setServicePricingType()
     * @uses Service::setReservationStatusType()
     * @uses Service::setServiceRPH()
     * @uses Service::setServiceInventoryCode()
     * @uses Service::setRatePlanCode()
     * @uses Service::setInventoryBlockCode()
     * @uses Service::setPriceGuaranteed()
     * @uses Service::setInclusive()
     * @uses Service::setQuantity()
     * @uses Service::setRelativePosition()
     * @uses Service::setOperationSchedules()
     * @uses Service::setMultimediaDescriptions()
     * @uses Service::setFeatures()
     * @uses Service::setDescriptiveText()
     * @uses Service::setIncluded()
     * @uses Service::setCode()
     * @uses Service::setBusinessServiceCode()
     * @uses Service::setExistsCode()
     * @uses Service::setCodeDetail()
     * @uses Service::setAvailableToAnyGuest()
     * @uses Service::setInvCode()
     * @uses Service::setProximityCode()
     * @uses Service::setMealPlanCode()
     * @uses Service::setSort()
     * @uses Service::setMeetingRoomCode()
     * @param \rdyescapiacontent\StructType\AmountType[] $price
     * @param \rdyescapiacontent\StructType\ResCommonDetailType $serviceDetails
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $servicePricingType
     * @param string $reservationStatusType
     * @param string $serviceRPH
     * @param string $serviceInventoryCode
     * @param string $ratePlanCode
     * @param string $inventoryBlockCode
     * @param bool $priceGuaranteed
     * @param bool $inclusive
     * @param int $quantity
     * @param \rdyescapiacontent\StructType\RelativePositionType $relativePosition
     * @param \rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules
     * @param \rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param \rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature $features
     * @param string $descriptiveText
     * @param bool $included
     * @param string $code
     * @param string $businessServiceCode
     * @param string $existsCode
     * @param string $codeDetail
     * @param bool $availableToAnyGuest
     * @param string $invCode
     * @param string $proximityCode
     * @param string $mealPlanCode
     * @param int $sort
     * @param string $meetingRoomCode
     */
    public function __construct(array $price = array(), \rdyescapiacontent\StructType\ResCommonDetailType $serviceDetails = null, \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $servicePricingType = null, $reservationStatusType = null, $serviceRPH = null, $serviceInventoryCode = null, $ratePlanCode = null, $inventoryBlockCode = null, $priceGuaranteed = null, $inclusive = null, $quantity = null, \rdyescapiacontent\StructType\RelativePositionType $relativePosition = null, \rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules = null, \rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions = null, \rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature $features = null, $descriptiveText = null, $included = null, $code = null, $businessServiceCode = null, $existsCode = null, $codeDetail = null, $availableToAnyGuest = null, $invCode = null, $proximityCode = null, $mealPlanCode = null, $sort = null, $meetingRoomCode = null)
    {
        $this
            ->setPrice($price)
            ->setServiceDetails($serviceDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setServicePricingType($servicePricingType)
            ->setReservationStatusType($reservationStatusType)
            ->setServiceRPH($serviceRPH)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setRatePlanCode($ratePlanCode)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setPriceGuaranteed($priceGuaranteed)
            ->setInclusive($inclusive)
            ->setQuantity($quantity)
            ->setRelativePosition($relativePosition)
            ->setOperationSchedules($operationSchedules)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setFeatures($features)
            ->setDescriptiveText($descriptiveText)
            ->setIncluded($included)
            ->setCode($code)
            ->setBusinessServiceCode($businessServiceCode)
            ->setExistsCode($existsCode)
            ->setCodeDetail($codeDetail)
            ->setAvailableToAnyGuest($availableToAnyGuest)
            ->setInvCode($invCode)
            ->setProximityCode($proximityCode)
            ->setMealPlanCode($mealPlanCode)
            ->setSort($sort)
            ->setMeetingRoomCode($meetingRoomCode);
    }
    /**
     * Get Price value
     * @return \rdyescapiacontent\StructType\AmountType[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AmountType[] $price
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setPrice(array $price = array())
    {
        foreach ($price as $servicePriceItem) {
            // validation for constraint: itemType
            if (!$servicePriceItem instanceof \rdyescapiacontent\StructType\AmountType) {
                throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \rdyescapiacontent\StructType\AmountType, "%s" given', is_object($servicePriceItem) ? get_class($servicePriceItem) : gettype($servicePriceItem)), __LINE__);
            }
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\AmountType $item
     * @return \rdyescapiacontent\StructType\Service
     */
    public function addToPrice(\rdyescapiacontent\StructType\AmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\AmountType) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \rdyescapiacontent\StructType\AmountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceDetails value
     * @return \rdyescapiacontent\StructType\ResCommonDetailType|null
     */
    public function getServiceDetails()
    {
        return $this->ServiceDetails;
    }
    /**
     * Set ServiceDetails value
     * @param \rdyescapiacontent\StructType\ResCommonDetailType $serviceDetails
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setServiceDetails(\rdyescapiacontent\StructType\ResCommonDetailType $serviceDetails = null)
    {
        $this->ServiceDetails = $serviceDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ServicePricingType value
     * @return string|null
     */
    public function getServicePricingType()
    {
        return $this->ServicePricingType;
    }
    /**
     * Set ServicePricingType value
     * @uses \rdyescapiacontent\EnumType\PricingType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePricingType
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setServicePricingType($servicePricingType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PricingType::valueIsValid($servicePricingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicePricingType, implode(', ', \rdyescapiacontent\EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->ServicePricingType = $servicePricingType;
        return $this;
    }
    /**
     * Get ReservationStatusType value
     * @return string|null
     */
    public function getReservationStatusType()
    {
        return $this->ReservationStatusType;
    }
    /**
     * Set ReservationStatusType value
     * @uses \rdyescapiacontent\EnumType\PMS_ResStatusType::valueIsValid()
     * @uses \rdyescapiacontent\EnumType\PMS_ResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationStatusType
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setReservationStatusType($reservationStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapiacontent\EnumType\PMS_ResStatusType::valueIsValid($reservationStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reservationStatusType, implode(', ', \rdyescapiacontent\EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        $this->ReservationStatusType = $reservationStatusType;
        return $this;
    }
    /**
     * Get ServiceRPH value
     * @return string|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * Set ServiceRPH value
     * @param string $serviceRPH
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setServiceRPH($serviceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRPH) && !is_string($serviceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceRPH)), __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return $this->InventoryBlockCode;
    }
    /**
     * Set InventoryBlockCode value
     * @param string $inventoryBlockCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryBlockCode)), __LINE__);
        }
        $this->InventoryBlockCode = $inventoryBlockCode;
        return $this;
    }
    /**
     * Get PriceGuaranteed value
     * @return bool|null
     */
    public function getPriceGuaranteed()
    {
        return $this->PriceGuaranteed;
    }
    /**
     * Set PriceGuaranteed value
     * @param bool $priceGuaranteed
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setPriceGuaranteed($priceGuaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceGuaranteed) && !is_bool($priceGuaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceGuaranteed)), __LINE__);
        }
        $this->PriceGuaranteed = $priceGuaranteed;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return \rdyescapiacontent\StructType\RelativePositionType|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param \rdyescapiacontent\StructType\RelativePositionType $relativePosition
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setRelativePosition(\rdyescapiacontent\StructType\RelativePositionType $relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return \rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param \rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setOperationSchedules(\rdyescapiacontent\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \rdyescapiacontent\StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setMultimediaDescriptions(\rdyescapiacontent\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get Features value
     * @return \rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature $features
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setFeatures(\rdyescapiacontent\ArrayType\ArrayOfFeaturesTypeFeature $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BusinessServiceCode value
     * @return string|null
     */
    public function getBusinessServiceCode()
    {
        return $this->BusinessServiceCode;
    }
    /**
     * Set BusinessServiceCode value
     * @param string $businessServiceCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setBusinessServiceCode($businessServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessServiceCode) && !is_string($businessServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessServiceCode)), __LINE__);
        }
        $this->BusinessServiceCode = $businessServiceCode;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get AvailableToAnyGuest value
     * @return bool|null
     */
    public function getAvailableToAnyGuest()
    {
        return $this->AvailableToAnyGuest;
    }
    /**
     * Set AvailableToAnyGuest value
     * @param bool $availableToAnyGuest
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setAvailableToAnyGuest($availableToAnyGuest = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToAnyGuest) && !is_bool($availableToAnyGuest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableToAnyGuest)), __LINE__);
        }
        $this->AvailableToAnyGuest = $availableToAnyGuest;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Get MealPlanCode value
     * @return string|null
     */
    public function getMealPlanCode()
    {
        return $this->MealPlanCode;
    }
    /**
     * Set MealPlanCode value
     * @param string $mealPlanCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setMealPlanCode($mealPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlanCode) && !is_string($mealPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealPlanCode)), __LINE__);
        }
        $this->MealPlanCode = $mealPlanCode;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !is_numeric($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get MeetingRoomCode value
     * @return string|null
     */
    public function getMeetingRoomCode()
    {
        return $this->MeetingRoomCode;
    }
    /**
     * Set MeetingRoomCode value
     * @param string $meetingRoomCode
     * @return \rdyescapiacontent\StructType\Service
     */
    public function setMeetingRoomCode($meetingRoomCode = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomCode) && !is_string($meetingRoomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetingRoomCode)), __LINE__);
        }
        $this->MeetingRoomCode = $meetingRoomCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
