<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceType StructType
 * @subpackage Structs
 */
class InsuranceType extends AbstractStructBase
{
    /**
     * The InsuredName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PersonNameType
     */
    public $InsuredName;
    /**
     * The InsuranceCompany
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType
     */
    public $InsuranceCompany;
    /**
     * The Underwriter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType
     */
    public $Underwriter;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The InsuranceType
     * @var string
     */
    public $InsuranceType;
    /**
     * The PolicyNumber
     * @var string
     */
    public $PolicyNumber;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for InsuranceType
     * @uses InsuranceType::setInsuredName()
     * @uses InsuranceType::setInsuranceCompany()
     * @uses InsuranceType::setUnderwriter()
     * @uses InsuranceType::setShareSynchInd()
     * @uses InsuranceType::setShareMarketInd()
     * @uses InsuranceType::setInsuranceType()
     * @uses InsuranceType::setPolicyNumber()
     * @uses InsuranceType::setEffectiveDate()
     * @uses InsuranceType::setExpireDate()
     * @uses InsuranceType::setRPH()
     * @param \rdyescapiacontent\StructType\PersonNameType $insuredName
     * @param \rdyescapiacontent\StructType\CompanyNameType $insuranceCompany
     * @param \rdyescapiacontent\StructType\CompanyNameType $underwriter
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $insuranceType
     * @param string $policyNumber
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $rPH
     */
    public function __construct(\rdyescapiacontent\StructType\PersonNameType $insuredName = null, \rdyescapiacontent\StructType\CompanyNameType $insuranceCompany = null, \rdyescapiacontent\StructType\CompanyNameType $underwriter = null, $shareSynchInd = null, $shareMarketInd = null, $insuranceType = null, $policyNumber = null, $effectiveDate = null, $expireDate = null, $rPH = null)
    {
        $this
            ->setInsuredName($insuredName)
            ->setInsuranceCompany($insuranceCompany)
            ->setUnderwriter($underwriter)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setInsuranceType($insuranceType)
            ->setPolicyNumber($policyNumber)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRPH($rPH);
    }
    /**
     * Get InsuredName value
     * @return \rdyescapiacontent\StructType\PersonNameType|null
     */
    public function getInsuredName()
    {
        return $this->InsuredName;
    }
    /**
     * Set InsuredName value
     * @param \rdyescapiacontent\StructType\PersonNameType $insuredName
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setInsuredName(\rdyescapiacontent\StructType\PersonNameType $insuredName = null)
    {
        $this->InsuredName = $insuredName;
        return $this;
    }
    /**
     * Get InsuranceCompany value
     * @return \rdyescapiacontent\StructType\CompanyNameType|null
     */
    public function getInsuranceCompany()
    {
        return $this->InsuranceCompany;
    }
    /**
     * Set InsuranceCompany value
     * @param \rdyescapiacontent\StructType\CompanyNameType $insuranceCompany
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setInsuranceCompany(\rdyescapiacontent\StructType\CompanyNameType $insuranceCompany = null)
    {
        $this->InsuranceCompany = $insuranceCompany;
        return $this;
    }
    /**
     * Get Underwriter value
     * @return \rdyescapiacontent\StructType\CompanyNameType|null
     */
    public function getUnderwriter()
    {
        return $this->Underwriter;
    }
    /**
     * Set Underwriter value
     * @param \rdyescapiacontent\StructType\CompanyNameType $underwriter
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setUnderwriter(\rdyescapiacontent\StructType\CompanyNameType $underwriter = null)
    {
        $this->Underwriter = $underwriter;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get InsuranceType value
     * @return string|null
     */
    public function getInsuranceType()
    {
        return $this->InsuranceType;
    }
    /**
     * Set InsuranceType value
     * @param string $insuranceType
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setInsuranceType($insuranceType = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceType) && !is_string($insuranceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceType)), __LINE__);
        }
        $this->InsuranceType = $insuranceType;
        return $this;
    }
    /**
     * Get PolicyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->PolicyNumber;
    }
    /**
     * Set PolicyNumber value
     * @param string $policyNumber
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyNumber)), __LINE__);
        }
        $this->PolicyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\InsuranceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
