<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItemsType StructType
 * @subpackage Structs
 */
class ImageItemsType extends AbstractStructBase
{
    /**
     * The ImageItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ImageItem[]
     */
    public $ImageItem;
    /**
     * The MoreData
     * @var bool
     */
    public $MoreData;
    /**
     * Constructor method for ImageItemsType
     * @uses ImageItemsType::setImageItem()
     * @uses ImageItemsType::setMoreData()
     * @param \rdyescapiacontent\StructType\ImageItem[] $imageItem
     * @param bool $moreData
     */
    public function __construct(array $imageItem = array(), $moreData = null)
    {
        $this
            ->setImageItem($imageItem)
            ->setMoreData($moreData);
    }
    /**
     * Get ImageItem value
     * @return \rdyescapiacontent\StructType\ImageItem[]|null
     */
    public function getImageItem()
    {
        return $this->ImageItem;
    }
    /**
     * Set ImageItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ImageItem[] $imageItem
     * @return \rdyescapiacontent\StructType\ImageItemsType
     */
    public function setImageItem(array $imageItem = array())
    {
        foreach ($imageItem as $imageItemsTypeImageItemItem) {
            // validation for constraint: itemType
            if (!$imageItemsTypeImageItemItem instanceof \rdyescapiacontent\StructType\ImageItem) {
                throw new \InvalidArgumentException(sprintf('The ImageItem property can only contain items of \rdyescapiacontent\StructType\ImageItem, "%s" given', is_object($imageItemsTypeImageItemItem) ? get_class($imageItemsTypeImageItemItem) : gettype($imageItemsTypeImageItemItem)), __LINE__);
            }
        }
        $this->ImageItem = $imageItem;
        return $this;
    }
    /**
     * Add item to ImageItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ImageItem $item
     * @return \rdyescapiacontent\StructType\ImageItemsType
     */
    public function addToImageItem(\rdyescapiacontent\StructType\ImageItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ImageItem) {
            throw new \InvalidArgumentException(sprintf('The ImageItem property can only contain items of \rdyescapiacontent\StructType\ImageItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ImageItem[] = $item;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \rdyescapiacontent\StructType\ImageItemsType
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\ImageItemsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
