<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\PaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\RelatedTravelerType[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\DocumentType[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\CompanyNameType
     */
    public $EmployerInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * @var string
     */
    public $LockoutType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The VIP_Indicator
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setRelatedTraveler()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setGender()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setBirthDate()
     * @uses CustomerType::setCurrencyCode()
     * @uses CustomerType::setDecimalPlaces()
     * @uses CustomerType::setVIP_Indicator()
     * @param \rdyescapiacontent\StructType\PersonNameType $personName
     * @param \rdyescapiacontent\StructType\Telephone[] $telephone
     * @param \rdyescapiacontent\StructType\EmailType[] $email
     * @param \rdyescapiacontent\StructType\Address[] $address
     * @param \rdyescapiacontent\StructType\URL_Type[] $uRL
     * @param \rdyescapiacontent\StructType\CitizenCountryName[] $citizenCountryName
     * @param string[] $physChallName
     * @param string[] $petInfo
     * @param \rdyescapiacontent\StructType\PaymentFormType[] $paymentForm
     * @param \rdyescapiacontent\StructType\RelatedTravelerType[] $relatedTraveler
     * @param \rdyescapiacontent\StructType\ContactPersonType[] $contactPerson
     * @param \rdyescapiacontent\StructType\DocumentType[] $document
     * @param \rdyescapiacontent\StructType\CustLoyalty[] $custLoyalty
     * @param \rdyescapiacontent\StructType\EmployeeInfoType[] $employeeInfo
     * @param \rdyescapiacontent\StructType\CompanyNameType $employerInfo
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $gender
     * @param bool $deceased
     * @param string $lockoutType
     * @param string $birthDate
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $vIP_Indicator
     */
    public function __construct(\rdyescapiacontent\StructType\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), \rdyescapiacontent\StructType\CompanyNameType $employerInfo = null, \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null, $gender = null, $deceased = null, $lockoutType = null, $birthDate = null, $currencyCode = null, $decimalPlaces = null, $vIP_Indicator = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setVIP_Indicator($vIP_Indicator);
    }
    /**
     * Get PersonName value
     * @return \rdyescapiacontent\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapiacontent\StructType\PersonNameType $personName
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setPersonName(\rdyescapiacontent\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \rdyescapiacontent\StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Telephone[] $telephone
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \rdyescapiacontent\StructType\Telephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapiacontent\StructType\Telephone, "%s" given', is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : gettype($customerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Telephone $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToTelephone(\rdyescapiacontent\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapiacontent\StructType\Telephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapiacontent\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmailType[] $email
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \rdyescapiacontent\StructType\EmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapiacontent\StructType\EmailType, "%s" given', is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : gettype($customerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmailType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToEmail(\rdyescapiacontent\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapiacontent\StructType\EmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapiacontent\StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Address[] $address
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \rdyescapiacontent\StructType\Address) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapiacontent\StructType\Address, "%s" given', is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : gettype($customerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Address $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToAddress(\rdyescapiacontent\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapiacontent\StructType\Address, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapiacontent\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\URL_Type[] $uRL
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        foreach ($uRL as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \rdyescapiacontent\StructType\URL_Type) {
                throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \rdyescapiacontent\StructType\URL_Type, "%s" given', is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : gettype($customerTypeURLItem)), __LINE__);
            }
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\URL_Type $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToURL(\rdyescapiacontent\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \rdyescapiacontent\StructType\URL_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \rdyescapiacontent\StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CitizenCountryName[] $citizenCountryName
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        foreach ($citizenCountryName as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \rdyescapiacontent\StructType\CitizenCountryName) {
                throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \rdyescapiacontent\StructType\CitizenCountryName, "%s" given', is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : gettype($customerTypeCitizenCountryNameItem)), __LINE__);
            }
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CitizenCountryName $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToCitizenCountryName(\rdyescapiacontent\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \rdyescapiacontent\StructType\CitizenCountryName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return string[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param string[] $physChallName
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        foreach ($physChallName as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePhysChallNameItem)) {
                throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : gettype($customerTypePhysChallNameItem)), __LINE__);
            }
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToPhysChallName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return string[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param string[] $petInfo
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        foreach ($petInfo as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePetInfoItem)) {
                throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : gettype($customerTypePetInfoItem)), __LINE__);
            }
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \rdyescapiacontent\StructType\PaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormType[] $paymentForm
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        foreach ($paymentForm as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \rdyescapiacontent\StructType\PaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \rdyescapiacontent\StructType\PaymentFormType, "%s" given', is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : gettype($customerTypePaymentFormItem)), __LINE__);
            }
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\PaymentFormType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToPaymentForm(\rdyescapiacontent\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \rdyescapiacontent\StructType\PaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return \rdyescapiacontent\StructType\RelatedTravelerType[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\RelatedTravelerType[] $relatedTraveler
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        foreach ($relatedTraveler as $customerTypeRelatedTravelerItem) {
            // validation for constraint: itemType
            if (!$customerTypeRelatedTravelerItem instanceof \rdyescapiacontent\StructType\RelatedTravelerType) {
                throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \rdyescapiacontent\StructType\RelatedTravelerType, "%s" given', is_object($customerTypeRelatedTravelerItem) ? get_class($customerTypeRelatedTravelerItem) : gettype($customerTypeRelatedTravelerItem)), __LINE__);
            }
        }
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\RelatedTravelerType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToRelatedTraveler(\rdyescapiacontent\StructType\RelatedTravelerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\RelatedTravelerType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \rdyescapiacontent\StructType\RelatedTravelerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \rdyescapiacontent\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ContactPersonType[] $contactPerson
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        foreach ($contactPerson as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerTypeContactPersonItem instanceof \rdyescapiacontent\StructType\ContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \rdyescapiacontent\StructType\ContactPersonType, "%s" given', is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : gettype($customerTypeContactPersonItem)), __LINE__);
            }
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\ContactPersonType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToContactPerson(\rdyescapiacontent\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \rdyescapiacontent\StructType\ContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \rdyescapiacontent\StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\DocumentType[] $document
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \rdyescapiacontent\StructType\DocumentType) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \rdyescapiacontent\StructType\DocumentType, "%s" given', is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : gettype($customerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\DocumentType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToDocument(\rdyescapiacontent\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \rdyescapiacontent\StructType\DocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \rdyescapiacontent\StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CustLoyalty[] $custLoyalty
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \rdyescapiacontent\StructType\CustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \rdyescapiacontent\StructType\CustLoyalty, "%s" given', is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : gettype($customerTypeCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\CustLoyalty $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToCustLoyalty(\rdyescapiacontent\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \rdyescapiacontent\StructType\CustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapiacontent\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmployeeInfoItem instanceof \rdyescapiacontent\StructType\EmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapiacontent\StructType\EmployeeInfoType, "%s" given', is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : gettype($customerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\EmployeeInfoType $item
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function addToEmployeeInfo(\rdyescapiacontent\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapiacontent\StructType\EmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return \rdyescapiacontent\StructType\CompanyNameType|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param \rdyescapiacontent\StructType\CompanyNameType $employerInfo
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setEmployerInfo(\rdyescapiacontent\StructType\CompanyNameType $employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapiacontent\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setTPA_Extensions(\rdyescapiacontent\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
