<?php

namespace rdyescapiacontent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicUnitInfoType StructType
 * @subpackage Structs
 */
class BasicUnitInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfVendorMessageType
     */
    public $VendorMessages;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\AddressInfoType
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber
     */
    public $ContactNumbers;
    /**
     * The Award
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\Award[]
     */
    public $Award;
    /**
     * The UnitAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitAmenityType[]
     */
    public $UnitAmenity;
    /**
     * The UnitSummary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \rdyescapiacontent\StructType\UnitStayCandidateType
     */
    public $UnitSummary;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The UnitClassCode
     * @var string
     */
    public $UnitClassCode;
    /**
     * Constructor method for BasicUnitInfoType
     * @uses BasicUnitInfoType::setVendorMessages()
     * @uses BasicUnitInfoType::setPosition()
     * @uses BasicUnitInfoType::setAddress()
     * @uses BasicUnitInfoType::setContactNumbers()
     * @uses BasicUnitInfoType::setAward()
     * @uses BasicUnitInfoType::setUnitAmenity()
     * @uses BasicUnitInfoType::setUnitSummary()
     * @uses BasicUnitInfoType::setPropertyManagerCode()
     * @uses BasicUnitInfoType::setUnitCode()
     * @uses BasicUnitInfoType::setUnitName()
     * @uses BasicUnitInfoType::setInfoSource()
     * @uses BasicUnitInfoType::setInternalUnitCode()
     * @uses BasicUnitInfoType::setUnitHeadline()
     * @uses BasicUnitInfoType::setUnitClassCode()
     * @param \rdyescapiacontent\ArrayType\ArrayOfVendorMessageType $vendorMessages
     * @param \rdyescapiacontent\StructType\Position $position
     * @param \rdyescapiacontent\StructType\AddressInfoType $address
     * @param \rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers
     * @param \rdyescapiacontent\StructType\Award[] $award
     * @param \rdyescapiacontent\StructType\UnitAmenityType[] $unitAmenity
     * @param \rdyescapiacontent\StructType\UnitStayCandidateType $unitSummary
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $unitClassCode
     */
    public function __construct(\rdyescapiacontent\ArrayType\ArrayOfVendorMessageType $vendorMessages = null, \rdyescapiacontent\StructType\Position $position = null, \rdyescapiacontent\StructType\AddressInfoType $address = null, \rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers = null, array $award = array(), array $unitAmenity = array(), \rdyescapiacontent\StructType\UnitStayCandidateType $unitSummary = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $unitClassCode = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setPosition($position)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setAward($award)
            ->setUnitAmenity($unitAmenity)
            ->setUnitSummary($unitSummary)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setUnitClassCode($unitClassCode);
    }
    /**
     * Get VendorMessages value
     * @return \rdyescapiacontent\ArrayType\ArrayOfVendorMessageType|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \rdyescapiacontent\ArrayType\ArrayOfVendorMessageType $vendorMessages
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setVendorMessages(\rdyescapiacontent\ArrayType\ArrayOfVendorMessageType $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get Position value
     * @return \rdyescapiacontent\StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \rdyescapiacontent\StructType\Position $position
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setPosition(\rdyescapiacontent\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapiacontent\StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \rdyescapiacontent\StructType\AddressInfoType $address
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setAddress(\rdyescapiacontent\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setContactNumbers(\rdyescapiacontent\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Award value
     * @return \rdyescapiacontent\StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Award[] $award
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setAward(array $award = array())
    {
        foreach ($award as $basicUnitInfoTypeAwardItem) {
            // validation for constraint: itemType
            if (!$basicUnitInfoTypeAwardItem instanceof \rdyescapiacontent\StructType\Award) {
                throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \rdyescapiacontent\StructType\Award, "%s" given', is_object($basicUnitInfoTypeAwardItem) ? get_class($basicUnitInfoTypeAwardItem) : gettype($basicUnitInfoTypeAwardItem)), __LINE__);
            }
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\Award $item
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function addToAward(\rdyescapiacontent\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \rdyescapiacontent\StructType\Award, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get UnitAmenity value
     * @return \rdyescapiacontent\StructType\UnitAmenityType[]|null
     */
    public function getUnitAmenity()
    {
        return $this->UnitAmenity;
    }
    /**
     * Set UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitAmenityType[] $unitAmenity
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitAmenity(array $unitAmenity = array())
    {
        foreach ($unitAmenity as $basicUnitInfoTypeUnitAmenityItem) {
            // validation for constraint: itemType
            if (!$basicUnitInfoTypeUnitAmenityItem instanceof \rdyescapiacontent\StructType\UnitAmenityType) {
                throw new \InvalidArgumentException(sprintf('The UnitAmenity property can only contain items of \rdyescapiacontent\StructType\UnitAmenityType, "%s" given', is_object($basicUnitInfoTypeUnitAmenityItem) ? get_class($basicUnitInfoTypeUnitAmenityItem) : gettype($basicUnitInfoTypeUnitAmenityItem)), __LINE__);
            }
        }
        $this->UnitAmenity = $unitAmenity;
        return $this;
    }
    /**
     * Add item to UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapiacontent\StructType\UnitAmenityType $item
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function addToUnitAmenity(\rdyescapiacontent\StructType\UnitAmenityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapiacontent\StructType\UnitAmenityType) {
            throw new \InvalidArgumentException(sprintf('The UnitAmenity property can only contain items of \rdyescapiacontent\StructType\UnitAmenityType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitAmenity[] = $item;
        return $this;
    }
    /**
     * Get UnitSummary value
     * @return \rdyescapiacontent\StructType\UnitStayCandidateType|null
     */
    public function getUnitSummary()
    {
        return $this->UnitSummary;
    }
    /**
     * Set UnitSummary value
     * @param \rdyescapiacontent\StructType\UnitStayCandidateType $unitSummary
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitSummary(\rdyescapiacontent\StructType\UnitStayCandidateType $unitSummary = null)
    {
        $this->UnitSummary = $unitSummary;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get UnitClassCode value
     * @return string|null
     */
    public function getUnitClassCode()
    {
        return $this->UnitClassCode;
    }
    /**
     * Set UnitClassCode value
     * @param string $unitClassCode
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public function setUnitClassCode($unitClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitClassCode) && !is_string($unitClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitClassCode)), __LINE__);
        }
        $this->UnitClassCode = $unitClassCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapiacontent\StructType\BasicUnitInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
